/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.impl;

import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.Replicator;
import com.icfolson.aem.groovy.console.api.context.ScriptContext;
import de.valtech.aecu.api.groovy.console.bindings.ValidateAccessRights;
import de.valtech.aecu.api.groovy.console.bindings.accessrights.AccessRightValidator;
import de.valtech.aecu.core.groovy.console.bindings.accessrights.AccessRightValidatorComparator;
import de.valtech.aecu.core.groovy.console.bindings.accessrights.AccessValidatorContext;
import de.valtech.aecu.core.groovy.console.bindings.accessrights.ValidateAccessRightsTable;
import de.valtech.aecu.core.groovy.console.bindings.accessrights.validators.page.CreatePageAccessValidator;
import de.valtech.aecu.core.groovy.console.bindings.accessrights.validators.page.DeletePageAccessValidator;
import de.valtech.aecu.core.groovy.console.bindings.accessrights.validators.page.ModifyPageAccessValidator;
import de.valtech.aecu.core.groovy.console.bindings.accessrights.validators.page.ReadPageAccessValidator;
import de.valtech.aecu.core.groovy.console.bindings.accessrights.validators.page.ReplicatePageAccessValidator;
import de.valtech.aecu.core.groovy.console.bindings.accessrights.validators.resource.CreateAccessValidator;
import de.valtech.aecu.core.groovy.console.bindings.accessrights.validators.resource.DeleteAccessValidator;
import de.valtech.aecu.core.groovy.console.bindings.accessrights.validators.resource.ModifyAccessValidator;
import de.valtech.aecu.core.groovy.console.bindings.accessrights.validators.resource.ReadAccessValidator;
import de.valtech.aecu.core.groovy.console.bindings.accessrights.validators.resource.ReadAclAccessValidator;
import de.valtech.aecu.core.groovy.console.bindings.accessrights.validators.resource.ReplicateAccessValidator;
import de.valtech.aecu.core.groovy.console.bindings.accessrights.validators.resource.WriteAclAccessValidator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateAccessRightsImpl
implements ValidateAccessRights {
    private static final Logger LOG = LoggerFactory.getLogger(ValidateAccessRightsImpl.class);
    private Set<String> pathsToCheck = new HashSet<String>();
    private Set<String> authorizablesToCheck = new HashSet<String>();
    private List<AccessRightValidator> validators = new ArrayList<AccessRightValidator>();
    private Set<String> warnings = new LinkedHashSet<String>();
    private ResourceResolver resolver;
    private AccessValidatorContext context;
    private ScriptContext scriptContext;
    private boolean failOnError = false;

    public ValidateAccessRightsImpl(ResourceResolverFactory resourceResolverFactory, ResourceResolver resolver, Replicator replicator, ScriptContext scriptContext) throws RepositoryException {
        this.resolver = resolver;
        this.context = new AccessValidatorContext(resourceResolverFactory, resolver, replicator);
        this.scriptContext = scriptContext;
    }

    public ValidateAccessRights forPaths(String ... paths) {
        this.pathsToCheck.clear();
        for (String path : paths) {
            this.pathsToCheck.add(path);
        }
        return this;
    }

    public ValidateAccessRights forGroups(String ... groups) {
        this.authorizablesToCheck.clear();
        for (String authorizable : groups) {
            this.authorizablesToCheck.add(authorizable);
        }
        return this;
    }

    private void addValidators(ValidatorCreator creator, boolean checkAccessGranted) {
        List<Resource> resources = this.resolveResources();
        List<Group> groups = this.resolveGroups();
        for (Group group : groups) {
            for (Resource resource : resources) {
                this.validators.add(creator.createValidator(group, resource, checkAccessGranted));
            }
        }
    }

    public ValidateAccessRights canRead() {
        this.addValidators((authorizable, resource, checkAccessGranted) -> new ReadAccessValidator(authorizable, resource, this.context, checkAccessGranted), true);
        return this;
    }

    public ValidateAccessRights cannotRead() {
        this.addValidators((authorizable, resource, checkAccessGranted) -> new ReadAccessValidator(authorizable, resource, this.context, checkAccessGranted), false);
        return this;
    }

    public ValidateAccessRights canModify() {
        this.addValidators((authorizable, resource, checkAccessGranted) -> new ModifyAccessValidator(authorizable, resource, this.context, checkAccessGranted), true);
        return this;
    }

    public ValidateAccessRights cannotModify() {
        this.addValidators((authorizable, resource, checkAccessGranted) -> new ModifyAccessValidator(authorizable, resource, this.context, checkAccessGranted), false);
        return this;
    }

    public ValidateAccessRights canCreate() {
        this.addValidators((authorizable, resource, checkAccessGranted) -> new CreateAccessValidator(authorizable, resource, this.context, checkAccessGranted), true);
        return this;
    }

    public ValidateAccessRights cannotCreate() {
        this.addValidators((authorizable, resource, checkAccessGranted) -> new CreateAccessValidator(authorizable, resource, this.context, checkAccessGranted), false);
        return this;
    }

    public ValidateAccessRights canDelete() {
        this.addValidators((authorizable, resource, checkAccessGranted) -> new DeleteAccessValidator(authorizable, resource, this.context, checkAccessGranted), true);
        return this;
    }

    public ValidateAccessRights cannotDelete() {
        this.addValidators((authorizable, resource, checkAccessGranted) -> new DeleteAccessValidator(authorizable, resource, this.context, checkAccessGranted), false);
        return this;
    }

    public ValidateAccessRights canReplicate() {
        this.addValidators((authorizable, resource, checkAccessGranted) -> new ReplicateAccessValidator(authorizable, resource, this.context, checkAccessGranted), true);
        return this;
    }

    public ValidateAccessRights cannotReplicate() {
        this.addValidators((authorizable, resource, checkAccessGranted) -> new ReplicateAccessValidator(authorizable, resource, this.context, checkAccessGranted), false);
        return this;
    }

    public ValidateAccessRights canReadAcl() {
        this.addValidators((authorizable, resource, checkAccessGranted) -> new ReadAclAccessValidator(authorizable, resource, this.context, checkAccessGranted), true);
        return this;
    }

    public ValidateAccessRights cannotReadAcl() {
        this.addValidators((authorizable, resource, checkAccessGranted) -> new ReadAclAccessValidator(authorizable, resource, this.context, checkAccessGranted), false);
        return this;
    }

    public ValidateAccessRights canWriteAcl() {
        this.addValidators((authorizable, resource, checkAccessGranted) -> new WriteAclAccessValidator(authorizable, resource, this.context, checkAccessGranted), true);
        return this;
    }

    public ValidateAccessRights cannotWriteAcl() {
        this.addValidators((authorizable, resource, checkAccessGranted) -> new WriteAclAccessValidator(authorizable, resource, this.context, checkAccessGranted), false);
        return this;
    }

    public ValidateAccessRights canReadPage() {
        this.addValidators((authorizable, resource, checkAccessGranted) -> new ReadPageAccessValidator(authorizable, resource, this.context, checkAccessGranted), true);
        return this;
    }

    public ValidateAccessRights cannotReadPage() {
        this.addValidators((authorizable, resource, checkAccessGranted) -> new ReadPageAccessValidator(authorizable, resource, this.context, checkAccessGranted), false);
        return this;
    }

    public ValidateAccessRights canCreatePage(String templatePath) {
        this.addValidators((authorizable, resource, checkAccessGranted) -> new CreatePageAccessValidator(authorizable, resource, this.context, checkAccessGranted, templatePath), true);
        return this;
    }

    public ValidateAccessRights cannotCreatePage(String templatePath) {
        this.addValidators((authorizable, resource, checkAccessGranted) -> new CreatePageAccessValidator(authorizable, resource, this.context, checkAccessGranted, templatePath), false);
        return this;
    }

    public ValidateAccessRights canModifyPage() {
        this.addValidators((authorizable, resource, checkAccessGranted) -> new ModifyPageAccessValidator(authorizable, resource, this.context, checkAccessGranted), true);
        return this;
    }

    public ValidateAccessRights cannotModifyPage() {
        this.addValidators((authorizable, resource, checkAccessGranted) -> new ModifyPageAccessValidator(authorizable, resource, this.context, checkAccessGranted), false);
        return this;
    }

    public ValidateAccessRights canDeletePage() {
        this.addValidators((authorizable, resource, checkAccessGranted) -> new DeletePageAccessValidator(authorizable, resource, this.context, checkAccessGranted), true);
        return this;
    }

    public ValidateAccessRights cannotDeletePage() {
        this.addValidators((authorizable, resource, checkAccessGranted) -> new DeletePageAccessValidator(authorizable, resource, this.context, checkAccessGranted), false);
        return this;
    }

    public ValidateAccessRights canReplicatePage(ReplicationActionType type) {
        this.addValidators((authorizable, resource, checkAccessGranted) -> new ReplicatePageAccessValidator(authorizable, resource, this.context, checkAccessGranted, type), true);
        return this;
    }

    public ValidateAccessRights canReplicatePage() {
        this.addValidators((authorizable, resource, checkAccessGranted) -> new ReplicatePageAccessValidator(authorizable, resource, this.context, checkAccessGranted, ReplicationActionType.ACTIVATE), true);
        return this;
    }

    public ValidateAccessRights cannotReplicatePage() {
        this.addValidators((authorizable, resource, checkAccessGranted) -> new ReplicatePageAccessValidator(authorizable, resource, this.context, checkAccessGranted, ReplicationActionType.ACTIVATE), false);
        return this;
    }

    public ValidateAccessRights cannotReplicatePage(ReplicationActionType type) {
        this.addValidators((authorizable, resource, checkAccessGranted) -> new ReplicatePageAccessValidator(authorizable, resource, this.context, checkAccessGranted, type), false);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(boolean simulate) {
        try {
            this.validators.sort(new AccessRightValidatorComparator());
            ValidateAccessRightsTable table = new ValidateAccessRightsTable();
            for (AccessRightValidator validator : this.validators) {
                table.add(validator, simulate);
            }
            StringBuilder output = new StringBuilder();
            output.append(String.join((CharSequence)"\n", this.warnings));
            output.append("\n");
            output.append(table.getText());
            output.append("\n\n");
            this.scriptContext.getPrintStream().append(output.toString());
            if (table.hasErrors() && this.failOnError) {
                throw new IllegalStateException("Rights check failed");
            }
        }
        finally {
            this.context.cleanup();
        }
    }

    public void validate() {
        this.validate(false);
    }

    public void simulate() {
        this.validate(true);
    }

    public ValidateAccessRights failOnError() {
        this.failOnError(true);
        return this;
    }

    public ValidateAccessRights failOnError(boolean fail) {
        this.failOnError = fail;
        return this;
    }

    private List<Group> resolveGroups() {
        ArrayList<Group> authorizables = new ArrayList<Group>();
        UserManager userManager = (UserManager)this.resolver.adaptTo(UserManager.class);
        for (String groupName : this.authorizablesToCheck) {
            try {
                Authorizable authorizable = userManager.getAuthorizable(groupName);
                if (authorizable != null && authorizable.isGroup()) {
                    authorizables.add((Group)authorizable);
                    continue;
                }
                this.warnings.add("Unable to resolve group " + groupName);
            }
            catch (RepositoryException e) {
                String message = "Unable to resolve group " + groupName;
                LOG.warn(message);
                this.warnings.add(message);
            }
        }
        return authorizables;
    }

    private List<Resource> resolveResources() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String path : this.pathsToCheck) {
            Resource resource = this.resolver.getResource(path);
            if (resource == null) {
                String message = "Unable to resolve path" + path;
                LOG.warn(message);
                this.warnings.add(message);
                continue;
            }
            resources.add(resource);
        }
        return resources;
    }

    @FunctionalInterface
    private static interface ValidatorCreator {
        public AccessRightValidator createValidator(Group var1, Resource var2, boolean var3);
    }
}

