/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.resource;

import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import de.valtech.aecu.core.groovy.console.bindings.impl.BindingContext;
import javax.jcr.Session;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;

public class ReplicateResourceAction
implements Action {
    private boolean activate;
    private BindingContext context;

    public ReplicateResourceAction(boolean activate, BindingContext context) {
        this.activate = activate;
        this.context = context;
    }

    @Override
    public String doAction(Resource resource) throws PersistenceException {
        String action = this.activate ? "activate" : "deactivate";
        String successMessage = "Replicated resource " + resource.getPath() + " with action " + action;
        if (this.context.isDryRun()) {
            return successMessage;
        }
        try {
            ReplicationActionType type = this.activate ? ReplicationActionType.ACTIVATE : ReplicationActionType.DEACTIVATE;
            this.context.getReplicator().replicate((Session)this.context.getResolver().adaptTo(Session.class), type, resource.getPath());
        }
        catch (ReplicationException e) {
            throw new PersistenceException("Unable to replicate " + resource.getPath());
        }
        return successMessage;
    }
}

