/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.accessrights.validators.page;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import de.valtech.aecu.api.groovy.console.bindings.accessrights.ValidationResult;
import de.valtech.aecu.core.groovy.console.bindings.accessrights.AccessValidatorContext;
import de.valtech.aecu.core.groovy.console.bindings.accessrights.validators.resource.ModifyAccessValidator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class ModifyPageAccessValidator
extends ModifyAccessValidator {
    protected static final String PROPERTY_NAME = "aecuValidationTestProperty";

    public ModifyPageAccessValidator(Group group, Resource resource, AccessValidatorContext context, boolean checkAccessGranted) {
        super(group, resource, context, checkAccessGranted);
    }

    @Override
    public ValidationResult validate(boolean simulate) {
        ValidationResult resourceResult = super.validate(simulate);
        if (!resourceResult.isSuccessful()) {
            return resourceResult;
        }
        if (!this.pageExists()) {
            return new ValidationResult(false, true, "Page not found");
        }
        return this.canModifyPageWithUser();
    }

    private boolean pageExists() {
        Page page = this.getContext().getAdminPageManager().getPage(this.getResource().getPath());
        return page != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationResult canModifyPageWithUser() {
        AccessValidatorContext.TestUser testUser = this.getContext().getTestUserForGroup(this.group);
        if (testUser == null) {
            return new ValidationResult(true, false, "Unable to create test user");
        }
        PageManager userPageManager = (PageManager)testUser.getResolver().adaptTo(PageManager.class);
        Page page = userPageManager.getPage(this.getResource().getPath());
        if (page == null) {
            return new ValidationResult(this.getCheckAccessGranted(), false, "Cannot read page");
        }
        try {
            Resource contentResource = page.getContentResource();
            if (contentResource == null) {
                ValidationResult validationResult = new ValidationResult(this.getCheckAccessGranted(), false, "No jcr:content found");
                return validationResult;
            }
            ValueMap vm = (ValueMap)contentResource.adaptTo(ModifiableValueMap.class);
            if (vm == null) {
                ValidationResult validationResult = new ValidationResult(this.getCheckAccessGranted(), false, "No value map returned");
                return validationResult;
            }
            vm.put((Object)PROPERTY_NAME, (Object)"testvalue");
            Node node = (Node)contentResource.adaptTo(Node.class);
            if (node == null) {
                ValidationResult validationResult = new ValidationResult(this.getCheckAccessGranted(), false, "No node returned");
                return validationResult;
            }
            node.setProperty(PROPERTY_NAME, "testvalue");
        }
        catch (RepositoryException e) {
            ValidationResult validationResult = new ValidationResult(this.getCheckAccessGranted(), false, e.getMessage());
            return validationResult;
        }
        finally {
            testUser.getResolver().revert();
            testUser.getResolver().refresh();
        }
        return new ValidationResult(!this.getCheckAccessGranted(), false, "Cannot replicate page");
    }

    @Override
    public String getLabel() {
        return this.getCheckAccessGranted() ? "Modify Page" : "Cannot Modify Page";
    }
}

