/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.accessrights.validators;

import com.day.cq.security.util.CqActions;
import de.valtech.aecu.api.groovy.console.bindings.accessrights.AccessRightValidator;
import de.valtech.aecu.api.groovy.console.bindings.accessrights.ValidationResult;
import de.valtech.aecu.core.groovy.console.bindings.accessrights.AccessValidatorContext;
import java.util.Collection;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAccessRightsValidator
implements AccessRightValidator {
    private static final Logger LOG = LoggerFactory.getLogger(BaseAccessRightsValidator.class);
    public static final String RIGHT_READ = "read";
    public static final String RIGHT_MODIFY = "modify";
    public static final String RIGHT_CREATE = "create";
    public static final String RIGHT_DELETE = "delete";
    public static final String RIGHT_READ_ACL = "acl_read";
    public static final String RIGHT_WRITE_ACL = "acl_edit";
    public static final String RIGHT_REPLICATE = "replicate";
    protected Group group;
    private Resource resource;
    private AccessValidatorContext context;
    private boolean checkAccessGranted;

    protected BaseAccessRightsValidator(Group group, Resource resource, AccessValidatorContext context, boolean checkAccessGranted) {
        this.group = group;
        this.resource = resource;
        this.context = context;
        this.checkAccessGranted = checkAccessGranted;
    }

    public String getGroupId() {
        try {
            return this.group.getID();
        }
        catch (RepositoryException e) {
            LOG.error("Group cannot be resolved", (Throwable)e);
            return "";
        }
    }

    public Resource getResource() {
        return this.resource;
    }

    protected boolean getCheckAccessGranted() {
        return this.checkAccessGranted;
    }

    public String toString() {
        return this.getGroupId() + " - " + this.resource.getPath() + " - " + this.getLabel();
    }

    protected ValidationResult checkAction(String action) {
        CqActions actions = this.context.getCqActions();
        try {
            Collection allowedActions = actions.getAllowedActions(this.resource.getPath(), this.context.getPrincipals((Authorizable)this.group));
            boolean granted = allowedActions.contains(action);
            boolean failed = this.checkAccessGranted ? !granted : granted;
            String message = failed ? "Wrong permissions" : null;
            return new ValidationResult(failed, false, message);
        }
        catch (RepositoryException e) {
            LOG.error("Unable to check actions", (Throwable)e);
            return new ValidationResult(true, false, e.getMessage());
        }
    }

    public AccessValidatorContext getContext() {
        return this.context;
    }
}

