/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.resource;

import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class CreateResource
implements Action {
    private String name;
    private Map<String, Object> properties;
    private String relativePath;
    private ResourceResolver resourceResolver;

    public CreateResource(@Nonnull String name, @Nonnull Map<String, Object> properties, String relativePath, @Nonnull ResourceResolver resourceResolver) {
        this.name = name;
        this.properties = properties;
        this.relativePath = relativePath;
        this.resourceResolver = resourceResolver;
    }

    @Override
    public String doAction(@Nonnull Resource resource) throws PersistenceException {
        Resource destinationResource = resource;
        if (StringUtils.isNotBlank((CharSequence)this.relativePath)) {
            destinationResource = this.resourceResolver.getResource(resource, this.relativePath);
        }
        if (destinationResource != null) {
            Resource newResource = this.resourceResolver.create(destinationResource, this.name, this.properties);
            return "Created " + newResource.getPath();
        }
        return "WARNING: could not read destination resource at " + this.relativePath;
    }
}

