/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.impl;

import com.icfolson.aem.groovy.console.api.ScriptContext;
import de.valtech.aecu.api.groovy.console.bindings.ContentUpgrade;
import de.valtech.aecu.api.groovy.console.bindings.CustomResourceAction;
import de.valtech.aecu.api.groovy.console.bindings.filters.ANDFilter;
import de.valtech.aecu.api.groovy.console.bindings.filters.FilterBy;
import de.valtech.aecu.api.groovy.console.bindings.filters.FilterByHasProperty;
import de.valtech.aecu.api.groovy.console.bindings.filters.FilterByMultiValuePropContains;
import de.valtech.aecu.api.groovy.console.bindings.filters.FilterByNodeName;
import de.valtech.aecu.api.groovy.console.bindings.filters.FilterByNodeNameRegex;
import de.valtech.aecu.api.groovy.console.bindings.filters.FilterByPathRegex;
import de.valtech.aecu.api.groovy.console.bindings.filters.FilterByProperties;
import de.valtech.aecu.api.groovy.console.bindings.filters.FilterByProperty;
import de.valtech.aecu.api.groovy.console.bindings.filters.FilterByPropertyRegex;
import de.valtech.aecu.api.service.AecuException;
import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import de.valtech.aecu.core.groovy.console.bindings.actions.multivalue.AddMultiValues;
import de.valtech.aecu.core.groovy.console.bindings.actions.multivalue.RemoveMultiValues;
import de.valtech.aecu.core.groovy.console.bindings.actions.multivalue.ReplaceMultiValues;
import de.valtech.aecu.core.groovy.console.bindings.actions.page.AddPageTagsAction;
import de.valtech.aecu.core.groovy.console.bindings.actions.page.DeletePageAction;
import de.valtech.aecu.core.groovy.console.bindings.actions.page.RemovePageTagsAction;
import de.valtech.aecu.core.groovy.console.bindings.actions.page.RenderPageAction;
import de.valtech.aecu.core.groovy.console.bindings.actions.page.ReplicatePageAction;
import de.valtech.aecu.core.groovy.console.bindings.actions.page.SetPageTagsAction;
import de.valtech.aecu.core.groovy.console.bindings.actions.page.TreeActivatePageAction;
import de.valtech.aecu.core.groovy.console.bindings.actions.print.PrintJson;
import de.valtech.aecu.core.groovy.console.bindings.actions.print.PrintPath;
import de.valtech.aecu.core.groovy.console.bindings.actions.print.PrintProperty;
import de.valtech.aecu.core.groovy.console.bindings.actions.properties.CopyPropertyToRelativePath;
import de.valtech.aecu.core.groovy.console.bindings.actions.properties.DeleteProperty;
import de.valtech.aecu.core.groovy.console.bindings.actions.properties.MovePropertyToRelativePath;
import de.valtech.aecu.core.groovy.console.bindings.actions.properties.RenameProperty;
import de.valtech.aecu.core.groovy.console.bindings.actions.properties.SetProperty;
import de.valtech.aecu.core.groovy.console.bindings.actions.resource.CopyResourceToRelativePath;
import de.valtech.aecu.core.groovy.console.bindings.actions.resource.CreateResource;
import de.valtech.aecu.core.groovy.console.bindings.actions.resource.CustomAction;
import de.valtech.aecu.core.groovy.console.bindings.actions.resource.DeleteResource;
import de.valtech.aecu.core.groovy.console.bindings.actions.resource.MoveResourceToPathRegex;
import de.valtech.aecu.core.groovy.console.bindings.actions.resource.MoveResourceToRelativePath;
import de.valtech.aecu.core.groovy.console.bindings.actions.resource.RenameResource;
import de.valtech.aecu.core.groovy.console.bindings.actions.resource.ReplaceResourcePropertyValues;
import de.valtech.aecu.core.groovy.console.bindings.actions.resource.ReplaceResourcePropertyValuesRegex;
import de.valtech.aecu.core.groovy.console.bindings.actions.resource.ReplicateResourceAction;
import de.valtech.aecu.core.groovy.console.bindings.impl.BindingContext;
import de.valtech.aecu.core.groovy.console.bindings.traversers.ForChildResourcesOf;
import de.valtech.aecu.core.groovy.console.bindings.traversers.ForDescendantResourcesOf;
import de.valtech.aecu.core.groovy.console.bindings.traversers.ForQuery;
import de.valtech.aecu.core.groovy.console.bindings.traversers.ForResources;
import de.valtech.aecu.core.groovy.console.bindings.traversers.TraversData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentUpgradeImpl
implements ContentUpgrade {
    private static final Logger LOG = LoggerFactory.getLogger(ContentUpgrade.class);
    private BindingContext context = null;
    private ScriptContext scriptContext;
    private List<TraversData> traversals = new ArrayList<TraversData>();
    private FilterBy filter = null;
    private List<Action> actions = new ArrayList<Action>();

    public ContentUpgradeImpl(@Nonnull ResourceResolver resourceResolver, ScriptContext scriptContext) {
        this.context = new BindingContext(resourceResolver);
        this.scriptContext = scriptContext;
    }

    public ContentUpgrade forResources(@Nonnull String[] paths) {
        this.traversals.add(new ForResources(paths));
        return this;
    }

    public ContentUpgrade forChildResourcesOf(@Nonnull String path) {
        this.traversals.add(new ForChildResourcesOf(path));
        return this;
    }

    public ContentUpgrade forDescendantResourcesOf(@Nonnull String path) {
        this.traversals.add(new ForDescendantResourcesOf(path, false));
        return this;
    }

    public ContentUpgrade forResourcesInSubtree(@Nonnull String path) {
        this.traversals.add(new ForDescendantResourcesOf(path, true));
        return this;
    }

    public ContentUpgrade forResourcesBySql2Query(String query) {
        this.traversals.add(new ForQuery(query, "JCR-SQL2"));
        return this;
    }

    public ContentUpgrade filterByProperties(@Nonnull Map<String, Object> conditionProperties) {
        this.addFilter((FilterBy)new FilterByProperties(conditionProperties));
        return this;
    }

    public ContentUpgrade filterByProperty(@Nonnull String name, Object value) {
        this.addFilter((FilterBy)new FilterByProperty(name, value));
        return this;
    }

    public ContentUpgrade filterByPropertyRegex(String name, String regex) {
        this.addFilter((FilterBy)new FilterByPropertyRegex(name, regex));
        return this;
    }

    public ContentUpgrade filterByAnyPropertyRegex(String regex) {
        this.addFilter((FilterBy)new FilterByPropertyRegex(null, regex));
        return this;
    }

    public ContentUpgrade filterByHasProperty(@Nonnull String name) {
        this.addFilter((FilterBy)new FilterByHasProperty(name));
        return this;
    }

    public ContentUpgrade filterByMultiValuePropContains(@Nonnull String name, @Nonnull Object[] conditionValues) {
        this.addFilter((FilterBy)new FilterByMultiValuePropContains(name, conditionValues));
        return this;
    }

    public ContentUpgrade filterByNodeName(@Nonnull String nodeName) {
        this.addFilter((FilterBy)new FilterByNodeName(nodeName));
        return this;
    }

    public ContentUpgrade filterByNodeNameRegex(@Nonnull String regex) {
        this.addFilter((FilterBy)new FilterByNodeNameRegex(regex));
        return this;
    }

    public ContentUpgrade filterByPathRegex(@Nonnull String regex) {
        this.addFilter((FilterBy)new FilterByPathRegex(regex));
        return this;
    }

    public ContentUpgrade filterWith(@Nonnull FilterBy filter) {
        this.addFilter(filter);
        return this;
    }

    private void addFilter(@Nonnull FilterBy filter) {
        if (this.filter == null) {
            this.filter = filter;
            return;
        }
        if (this.filter instanceof ANDFilter) {
            ((ANDFilter)this.filter).addFilter(filter);
        }
        ANDFilter newFilter = new ANDFilter(Arrays.asList(this.filter, filter));
        this.filter = newFilter;
    }

    public ContentUpgrade doSetProperty(@Nonnull String name, Object value) {
        this.actions.add(new SetProperty(name, value));
        return this;
    }

    public ContentUpgrade doDeleteProperty(@Nonnull String name) {
        this.actions.add(new DeleteProperty(name));
        return this;
    }

    public ContentUpgrade doRenameProperty(@Nonnull String oldName, @Nonnull String newName) {
        this.actions.add(new RenameProperty(oldName, newName));
        return this;
    }

    public ContentUpgrade doCopyPropertyToRelativePath(@Nonnull String name, String newName, @Nonnull String relativeResourcePath) {
        this.actions.add(new CopyPropertyToRelativePath(name, newName, this.context.getResolver(), relativeResourcePath));
        return this;
    }

    public ContentUpgrade doMovePropertyToRelativePath(@Nonnull String name, String newName, @Nonnull String relativeResourcePath) {
        this.actions.add(new MovePropertyToRelativePath(name, newName, this.context.getResolver(), relativeResourcePath));
        return this;
    }

    public ContentUpgrade doAddValuesToMultiValueProperty(@Nonnull String name, @Nonnull String[] values) {
        this.actions.add(new AddMultiValues(name, values));
        return this;
    }

    public ContentUpgrade doRemoveValuesOfMultiValueProperty(@Nonnull String name, @Nonnull String[] values) {
        this.actions.add(new RemoveMultiValues(name, values));
        return this;
    }

    public ContentUpgrade doReplaceValuesOfMultiValueProperty(@Nonnull String name, @Nonnull String[] oldValues, @Nonnull String[] newValues) {
        this.actions.add(new ReplaceMultiValues(name, oldValues, newValues));
        return this;
    }

    public ContentUpgrade doReplaceValueInAllProperties(String oldValue, String newValue) {
        this.actions.add(new ReplaceResourcePropertyValues(oldValue, newValue, Collections.emptyList()));
        return this;
    }

    public ContentUpgrade doReplaceValueInProperties(String oldValue, String newValue, String[] propertyNames) {
        this.actions.add(new ReplaceResourcePropertyValues(oldValue, newValue, Arrays.asList(propertyNames)));
        return this;
    }

    public ContentUpgrade doReplaceValueInAllPropertiesRegex(String searchRegex, String replacement) {
        this.actions.add(new ReplaceResourcePropertyValuesRegex(searchRegex, replacement, Collections.emptyList()));
        return this;
    }

    public ContentUpgrade doReplaceValueInPropertiesRegex(String searchRegex, String replacement, String[] propertyNames) {
        this.actions.add(new ReplaceResourcePropertyValuesRegex(searchRegex, replacement, Arrays.asList(propertyNames)));
        return this;
    }

    public ContentUpgrade doRename(String newName) {
        this.actions.add(new RenameResource(this.context.getResolver(), newName));
        return this;
    }

    public ContentUpgrade doCopyResourceToRelativePath(@Nonnull String relativePath) {
        this.actions.add(new CopyResourceToRelativePath(relativePath, this.context.getResolver()));
        return this;
    }

    public ContentUpgrade doMoveResourceToRelativePath(@Nonnull String relativePath) {
        this.actions.add(new MoveResourceToRelativePath(relativePath, this.context));
        return this;
    }

    public ContentUpgrade doMoveResourceToPathRegex(@Nonnull String matchPattern, @Nonnull String targetPathExpr) {
        this.actions.add(new MoveResourceToPathRegex(matchPattern, targetPathExpr, this.context));
        return this;
    }

    public ContentUpgrade doDeleteResource(String ... children) {
        this.actions.add(new DeleteResource(this.context.getResolver(), children));
        return this;
    }

    public ContentUpgrade doCreateResource(String name, String primaryType) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        propertyMap.put("jcr:primaryType", primaryType);
        this.actions.add(new CreateResource(name, propertyMap, null, this.context.getResolver()));
        return this;
    }

    public ContentUpgrade doCreateResource(String name, String primaryType, Map<String, Object> properties) {
        HashMap<String, Object> propertyMap = properties == null ? new HashMap<String, Object>() : properties;
        propertyMap.put("jcr:primaryType", primaryType);
        this.actions.add(new CreateResource(name, propertyMap, null, this.context.getResolver()));
        return this;
    }

    public ContentUpgrade doCreateResource(String name, String primaryType, String relativePath) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        propertyMap.put("jcr:primaryType", primaryType);
        this.actions.add(new CreateResource(name, propertyMap, relativePath, this.context.getResolver()));
        return this;
    }

    public ContentUpgrade doCreateResource(String name, String primaryType, Map<String, Object> properties, String relativePath) {
        HashMap<String, Object> propertyMap = properties == null ? new HashMap<String, Object>() : properties;
        propertyMap.put("jcr:primaryType", primaryType);
        this.actions.add(new CreateResource(name, propertyMap, relativePath, this.context.getResolver()));
        return this;
    }

    public ContentUpgrade doActivateResource() {
        this.actions.add(new ReplicateResourceAction(true, this.context));
        return this;
    }

    public ContentUpgrade doDeactivateResource() {
        this.actions.add(new ReplicateResourceAction(false, this.context));
        return this;
    }

    public ContentUpgrade doCustomResourceBasedAction(CustomResourceAction action) {
        this.actions.add(new CustomAction(action));
        return this;
    }

    public ContentUpgrade doActivateContainingPage() {
        this.actions.add(new ReplicatePageAction(true, this.context));
        return this;
    }

    public ContentUpgrade doTreeActivateContainingPage() {
        this.actions.add(new TreeActivatePageAction(false, this.context));
        return this;
    }

    public ContentUpgrade doTreeActivateContainingPage(boolean skipDeactivated) {
        this.actions.add(new TreeActivatePageAction(skipDeactivated, this.context));
        return this;
    }

    public ContentUpgrade doDeactivateContainingPage() {
        this.actions.add(new ReplicatePageAction(false, this.context));
        return this;
    }

    public ContentUpgrade doDeleteContainingPage() {
        this.actions.add(new DeletePageAction(this.context));
        return this;
    }

    public ContentUpgrade doAddTagsToContainingPage(String ... tags) {
        this.actions.add(new AddPageTagsAction(this.context, tags));
        return this;
    }

    public ContentUpgrade doSetTagsForContainingPage(String ... tags) {
        this.actions.add(new SetPageTagsAction(this.context, tags));
        return this;
    }

    public ContentUpgrade doRemoveTagsFromContainingPage(String ... tags) {
        this.actions.add(new RemovePageTagsAction(this.context, tags));
        return this;
    }

    public ContentUpgrade doCheckPageRendering() {
        return this.doCheckPageRendering(200);
    }

    public ContentUpgrade doCheckPageRendering(int code) {
        this.actions.add(new RenderPageAction(this.context, code, null, null));
        return this;
    }

    public ContentUpgrade doCheckPageRendering(String textPresent) {
        return this.doCheckPageRendering(textPresent, null);
    }

    public ContentUpgrade doCheckPageRendering(String textPresent, String textNotPresent) {
        this.actions.add(new RenderPageAction(this.context, 200, textPresent, textNotPresent));
        return this;
    }

    public ContentUpgrade printPath() {
        LOG.debug("printPath");
        this.actions.add(new PrintPath());
        return this;
    }

    public ContentUpgrade printProperty(@Nonnull String property) {
        LOG.debug("printProperty {}", (Object)property);
        this.actions.add(new PrintProperty(property));
        return this;
    }

    public ContentUpgrade printJson() {
        LOG.debug("printJson");
        this.actions.add(new PrintJson());
        return this;
    }

    public void run() throws PersistenceException, AecuException {
        LOG.debug("apply content upgrade");
        this.run(false);
    }

    public void dryRun() throws PersistenceException, AecuException {
        LOG.debug("apply content upgrade dry");
        this.run(true);
    }

    public void run(boolean dryRun) throws PersistenceException, AecuException {
        this.context.setDryRun(dryRun);
        StringBuilder output = new StringBuilder("Running content upgrade " + (dryRun ? "DRY" : "") + "...\n");
        for (TraversData traversal : this.traversals) {
            traversal.traverse(this.context, this.filter, this.actions, output, dryRun);
        }
        if (!dryRun) {
            this.context.getResolver().commit();
        }
        output.append("\n\n");
        this.scriptContext.getPrintStream().append(output);
    }
}

