/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.model.history;

import com.adobe.cq.commerce.common.ValueMapDecorator;
import com.adobe.granite.ui.components.ds.AbstractDataSource;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import de.valtech.aecu.api.service.AecuException;
import de.valtech.aecu.api.service.AecuService;
import de.valtech.aecu.api.service.HistoryEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
public class HistoryDataSource {
    private static final String ITEM_TYPE = "valtech/aecu/tools/history/dataitem";
    public static final String ATTR_HISTORY = "history";
    private static final Logger LOG = LoggerFactory.getLogger(DataSource.class);
    @SlingObject
    SlingHttpServletRequest request;
    @OSGiService
    AecuService aecuService;

    @PostConstruct
    public void setup() {
        String[] selectors = this.request.getRequestPathInfo().getSelectors();
        int offset = 0;
        int limit = 50;
        if (selectors.length > 1) {
            offset = Integer.parseInt(selectors[0]);
            limit = Integer.parseInt(selectors[1]);
        }
        this.request.setAttribute(DataSource.class.getName(), (Object)this.getResourceIterator(offset, limit));
    }

    private DataSource getResourceIterator(final int offset, final int limit) {
        return new AbstractDataSource(){

            public Iterator<Resource> iterator() {
                ArrayList<ValueMapResource> entries = new ArrayList<ValueMapResource>();
                try {
                    List historyEntries = HistoryDataSource.this.aecuService.getHistory(offset, limit + 1);
                    for (HistoryEntry historyEntry : historyEntries) {
                        ValueMapDecorator vm = new ValueMapDecorator(new HashMap());
                        vm.put((Object)HistoryDataSource.ATTR_HISTORY, (Object)historyEntry);
                        entries.add(new ValueMapResource(HistoryDataSource.this.request.getResourceResolver(), historyEntry.getRepositoryPath(), HistoryDataSource.ITEM_TYPE, (ValueMap)vm));
                    }
                }
                catch (AecuException e) {
                    LOG.error("Unable to read history entries", (Throwable)e);
                }
                return entries.iterator();
            }
        };
    }
}

