/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.model.execute;

import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import de.valtech.aecu.api.service.AecuException;
import de.valtech.aecu.api.service.AecuService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;

@Model(adaptables={SlingHttpServletRequest.class})
public class ExecuteDataSource {
    private static final String ITEM_TYPE = "valtech/aecu/tools/execute/dataitem";
    private static final String ALLOWED_PATH = "/var/groovyconsole/scripts";
    @SlingObject
    SlingHttpServletRequest request;
    @OSGiService
    private AecuService aecuService;

    @PostConstruct
    public void setup() throws AecuException {
        String path = this.request.getParameter("searchPath");
        ArrayList<ValueMapResource> entries = new ArrayList<ValueMapResource>();
        if (path != null && StringUtils.isNotEmpty((CharSequence)path) && path.startsWith(ALLOWED_PATH)) {
            List allowedScripts = this.aecuService.getFiles(path);
            ResourceResolver resourceResolver = this.request.getResourceResolver();
            for (String scriptPath : allowedScripts) {
                entries.add(new ValueMapResource(resourceResolver, scriptPath, ITEM_TYPE, null));
            }
        }
        SimpleDataSource ds = new SimpleDataSource(entries.iterator());
        this.request.setAttribute(DataSource.class.getName(), (Object)ds);
    }
}

