/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.jmx;

import com.adobe.granite.jmx.annotation.AnnotatedStandardMBean;
import de.valtech.aecu.api.service.AecuException;
import de.valtech.aecu.api.service.AecuService;
import de.valtech.aecu.api.service.ExecutionResult;
import de.valtech.aecu.api.service.HistoryEntry;
import de.valtech.aecu.core.jmx.AecuServiceMBean;
import java.util.List;
import javax.management.NotCompliantMBeanException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AecuServiceMBean.class}, immediate=true, property={"jmx.objectname=de.valtech:type=AECU", "pattern=/.*"})
public class AecuServiceMBeanImpl
extends AnnotatedStandardMBean
implements AecuServiceMBean {
    @Reference
    AecuService aecuService;

    public AecuServiceMBeanImpl() throws NotCompliantMBeanException {
        super(AecuServiceMBean.class);
    }

    @Override
    public String getVersion() {
        return this.aecuService.getVersion();
    }

    @Override
    public List<String> getFiles(String path) throws AecuException {
        return this.aecuService.getFiles(path);
    }

    @Override
    public String execute(String path) throws AecuException {
        HistoryEntry history = this.aecuService.createHistoryEntry();
        List files = this.aecuService.getFiles(path);
        StringBuilder result = new StringBuilder("Found " + files.size() + " files to execute\n\n");
        for (String file : files) {
            result.append(file + "\n");
            ExecutionResult singleResult = this.aecuService.execute(file);
            this.aecuService.storeExecutionInHistory(history, singleResult);
            result.append(singleResult.toString());
            result.append("\n\n");
        }
        this.aecuService.finishHistoryEntry(history);
        return result.toString();
    }

    @Override
    public String getHistory(int start, int count) throws AecuException {
        List entries = this.aecuService.getHistory(start, count);
        StringBuilder output = new StringBuilder();
        for (HistoryEntry entry : entries) {
            output.append(entry.toString() + "\n\n");
        }
        return output.toString();
    }
}

