/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.resource;

import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class MoveResourceToPathRegex
implements Action {
    private ResourceResolver resourceResolver;
    private String matchPattern;
    private String targetPathExpr;

    public MoveResourceToPathRegex(@Nonnull String matchPattern, @Nonnull String targetPathExpr, @Nonnull ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
        this.matchPattern = matchPattern;
        this.targetPathExpr = targetPathExpr;
    }

    @Override
    public String doAction(@Nonnull Resource resource) throws PersistenceException {
        String resourcePath = resource.getPath();
        if (resourcePath.matches(this.matchPattern)) {
            String targetPath = resourcePath.replaceAll(this.matchPattern, this.targetPathExpr);
            Resource destinationResource = this.resourceResolver.getResource(targetPath);
            if (destinationResource != null) {
                this.resourceResolver.move(resourcePath, targetPath);
                return "Moved " + resourcePath + " to path " + targetPath;
            }
            return "WARNING: could not read move destination resource " + targetPath;
        }
        return "INFO: resource " + resourcePath + " does not match path regex " + this.matchPattern + ", skipping";
    }
}

