/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.multivalue;

import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;

public class ReplaceMultiValues
implements Action {
    private String name;
    private String[] oldValues;
    private String[] newValues;

    public ReplaceMultiValues(@Nonnull String name, @Nonnull String[] oldValues, @Nonnull String[] newValues) {
        this.name = name;
        this.oldValues = Arrays.stream(oldValues).filter(Objects::nonNull).collect(Collectors.toList()).toArray(new String[0]);
        this.newValues = Arrays.stream(newValues).filter(Objects::nonNull).collect(Collectors.toList()).toArray(new String[0]);
    }

    @Override
    public String doAction(@Nonnull Resource resource) throws PersistenceException {
        ModifiableValueMap properties = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        if (properties != null) {
            Object[] currentValues = (String[])properties.get(this.name, String[].class);
            ArrayList valuesList = new ArrayList();
            if (currentValues != null && currentValues.length > 0) {
                Collections.addAll(valuesList, currentValues);
            }
            String warning = this.oldValues.length != this.newValues.length ? "WARNING: old values and new values length mismatch (old: " + Arrays.toString(this.oldValues) + " , new: " + Arrays.toString(this.newValues) + ") -> the smaller length will be considered\n" : "";
            for (int i = 0; i < this.oldValues.length && i < this.newValues.length; ++i) {
                Collections.replaceAll(valuesList, this.oldValues[i], this.newValues[i]);
            }
            properties.put((Object)this.name, (Object)valuesList.toArray(new String[0]));
            return warning + "Replacing values " + Arrays.toString(this.oldValues) + " with values " + Arrays.toString(this.newValues) + " for multi-value property " + this.name + ": " + Arrays.toString(currentValues) + " results in " + valuesList + " for resource " + resource.getPath();
        }
        return "WARNING: could not get ModifiableValueMap for resource " + resource.getPath();
    }
}

