/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.traversers;

import de.valtech.aecu.api.groovy.console.bindings.filters.FilterBy;
import de.valtech.aecu.api.service.AecuException;
import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import de.valtech.aecu.core.groovy.console.bindings.impl.BindingContext;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;

public abstract class TraversData {
    private static final int SAVE_LIMIT = 1000;
    private int saveCount = 0;

    public abstract void traverse(@Nonnull BindingContext var1, FilterBy var2, @Nonnull List<Action> var3, @Nonnull StringBuffer var4, boolean var5) throws PersistenceException, AecuException;

    protected boolean isResourceValid(Resource resource) {
        try {
            ValueMap values = resource.getValueMap();
            return values.get("jcr:primaryType", String.class) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    protected void applyActionsOnResource(@Nonnull Resource resource, FilterBy filter, List<Action> actions, StringBuffer stringBuffer, boolean dryRun) throws PersistenceException, AecuException {
        if (filter == null || filter.filter(resource, stringBuffer)) {
            ResourceResolver resolver = resource.getResourceResolver();
            this.runActions(stringBuffer, resource, actions);
            if (!dryRun) {
                this.save(resolver);
            }
        }
    }

    private void save(ResourceResolver resourceResolver) throws PersistenceException {
        ++this.saveCount;
        if (this.saveCount > 1000) {
            resourceResolver.commit();
            this.saveCount = 0;
        }
    }

    private void runActions(@Nonnull StringBuffer stringBuffer, @Nonnull Resource resource, @Nonnull List<Action> actions) throws PersistenceException, AecuException {
        for (Action action : actions) {
            String output = action.doAction(resource);
            if (!StringUtils.isNotBlank((CharSequence)output)) continue;
            stringBuffer.append(output + "\n");
        }
    }
}

