/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.resource;

import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class MoveResourceToRelativePath
implements Action {
    private String relativePath;
    private ResourceResolver resourceResolver;

    public MoveResourceToRelativePath(@Nonnull String relativePath, @Nonnull ResourceResolver resourceResolver) {
        this.relativePath = relativePath;
        this.resourceResolver = resourceResolver;
    }

    @Override
    public String doAction(@Nonnull Resource resource) throws PersistenceException {
        Resource destinationResource = this.resourceResolver.getResource(resource, this.relativePath);
        if (destinationResource != null) {
            String sourceAbsPAth = resource.getPath();
            String destinationAsPath = destinationResource.getPath();
            this.resourceResolver.move(sourceAbsPAth, destinationAsPath);
            return "Moved " + sourceAbsPAth + " to path " + destinationAsPath;
        }
        return "WARNING: could not read move destination resource " + this.relativePath;
    }
}

