/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.maintenance;

import de.valtech.aecu.core.history.HistoryUtil;
import de.valtech.aecu.core.maintenance.PurgeHistoryConfiguration;
import de.valtech.aecu.core.serviceuser.ServiceResourceResolverService;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.consumer.JobExecutionContext;
import org.apache.sling.event.jobs.consumer.JobExecutionResult;
import org.apache.sling.event.jobs.consumer.JobExecutor;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;

@Component(property={"granite.maintenance.name=AECUPurgeHistory", "granite.maintenance.title=AECU Purge History", "job.topics=com/adobe/granite/maintenance/job/AECUPurgeHistory"})
@Designate(ocd=PurgeHistoryConfiguration.class)
public class PurgeHistoryTask
implements JobExecutor {
    private PurgeHistoryConfiguration config;
    @Reference
    private ServiceResourceResolverService resolverService;
    @Reference
    private HistoryUtil historyUtil;

    @Activate
    public void activate(PurgeHistoryConfiguration config) {
        this.config = config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JobExecutionResult process(Job job, JobExecutionContext context) {
        try (ResourceResolver resolver = this.resolverService.getServiceResourceResolver();){
            this.historyUtil.purgeHistory(resolver, this.config.daysToKeep());
            resolver.commit();
            JobExecutionResult jobExecutionResult = context.result().message("Purged AECU history entries").succeeded();
            return jobExecutionResult;
        }
        catch (LoginException e) {
            return context.result().message("Service resolver failed with " + e.getMessage()).failed();
        }
        catch (PersistenceException e) {
            return context.result().message("Purge failed with " + e.getMessage()).failed();
        }
    }
}

