/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.traversers;

import de.valtech.aecu.api.groovy.console.bindings.filters.FilterBy;
import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import de.valtech.aecu.core.groovy.console.bindings.impl.BindingContext;
import de.valtech.aecu.core.groovy.console.bindings.traversers.TraversData;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class ForChildResourcesOf
implements TraversData {
    private String path;

    public ForChildResourcesOf(@Nonnull String path) {
        this.path = path;
    }

    @Override
    public void traverse(@Nonnull BindingContext context, FilterBy filter, @Nonnull List<Action> actions, @Nonnull StringBuffer stringBuffer, boolean dryRun) throws PersistenceException {
        ResourceResolver resourceResolver = context.getResolver();
        Resource parentResource = resourceResolver.getResource(this.path);
        if (parentResource != null) {
            Iterator resourceIterator = resourceResolver.listChildren(parentResource);
            while (resourceIterator.hasNext()) {
                Resource resource = (Resource)resourceIterator.next();
                if (!this.isResourceValid(resource) || filter != null && !filter.filter(resource)) continue;
                for (Action action : actions) {
                    stringBuffer.append(action.doAction(resource) + "\n");
                }
            }
            if (!dryRun) {
                resourceResolver.commit();
            }
        }
    }
}

