/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.resource;

import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.value.StringValue;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;

public class ReplaceResourcePropertyValues
implements Action {
    private String oldValue;
    private String newValue;
    private List<String> propertyNames;

    public ReplaceResourcePropertyValues(@Nonnull String oldValue, @Nonnull String newValue, @Nonnull List<String> propertyNames) {
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.propertyNames = new ArrayList<String>(propertyNames);
    }

    @Override
    public String doAction(@Nonnull Resource resource) throws PersistenceException {
        Node node = (Node)resource.adaptTo(Node.class);
        if (node == null) {
            return "";
        }
        boolean updated = false;
        try {
            PropertyIterator propertyIterator = node.getProperties();
            while (propertyIterator.hasNext()) {
                boolean propUpdated;
                Property property = propertyIterator.nextProperty();
                if (!this.doChangeProperty(property)) continue;
                if (property.isMultiple()) {
                    propUpdated = this.updateMulti(property);
                    updated = updated || propUpdated;
                    continue;
                }
                propUpdated = this.updateSingle(property);
                updated = updated || propUpdated;
            }
        }
        catch (RepositoryException e) {
            throw new PersistenceException("Replace failed for " + resource.getPath(), (Throwable)e);
        }
        if (updated) {
            return "Updated values from " + this.oldValue + " to " + this.newValue + " in " + resource.getPath();
        }
        return "";
    }

    private boolean updateSingle(Property property) throws RepositoryException {
        if (!this.valueMatches(property.getString())) {
            return false;
        }
        String newPropertyValue = this.getNewValue(property.getString());
        if (property.getString().equals(newPropertyValue)) {
            return false;
        }
        property.setValue(newPropertyValue);
        return true;
    }

    private boolean updateMulti(Property property) throws RepositoryException {
        Value[] values = property.getValues();
        boolean updated = false;
        for (int i = 0; i < values.length; ++i) {
            Value value = values[i];
            if (!this.valueMatches(value.getString())) continue;
            String newPropertyValue = this.getNewValue(value.getString());
            if (value.getString().equals(newPropertyValue)) continue;
            values[i] = new StringValue(newPropertyValue);
            updated = true;
        }
        if (updated) {
            property.setValue(values);
        }
        return updated;
    }

    protected boolean valueMatches(String value) {
        return value.contains(this.oldValue);
    }

    protected String getNewValue(String propertyValue) {
        return propertyValue.replace(this.oldValue, this.newValue);
    }

    private boolean doChangeProperty(Property property) throws RepositoryException {
        if (property.getType() != 1) {
            return false;
        }
        String propertyName = property.getName();
        return this.propertyNames.isEmpty() || this.propertyNames.contains(propertyName);
    }
}

