/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.page;

import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.Page;
import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import de.valtech.aecu.core.groovy.console.bindings.impl.BindingContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;

public class SetPageTagsAction
implements Action {
    private BindingContext context;
    private String[] tags;

    public SetPageTagsAction(BindingContext context, String ... tags) {
        this.context = context;
        this.tags = (String[])tags.clone();
    }

    @Override
    public String doAction(Resource resource) throws PersistenceException {
        Page page = this.context.getPageManager().getContainingPage(resource);
        if (page == null) {
            return "Unable to find a page for resource " + resource.getPath();
        }
        List<Tag> tagsToSet = this.getTagsToSet();
        String successMessage = "Set page tags on " + page.getPath() + ": " + this.getTagListAsString(tagsToSet);
        if (this.context.isDryRun()) {
            return successMessage;
        }
        TagManager tagManager = this.context.getTagManager();
        tagManager.setTags(page.getContentResource(), tagsToSet.toArray(new Tag[tagsToSet.size()]));
        return successMessage;
    }

    private List<Tag> getTagsToSet() throws PersistenceException {
        TagManager tagManager = this.context.getTagManager();
        ArrayList<Tag> toSet = new ArrayList<Tag>();
        for (String newTagName : this.tags) {
            Tag tag = tagManager.resolve(newTagName);
            if (tag == null) {
                throw new PersistenceException("Tag " + newTagName + " does not exist.\n");
            }
            toSet.add(tag);
        }
        return toSet;
    }

    private String getTagListAsString(List<Tag> tags) {
        ArrayList<String> tagIds = new ArrayList<String>();
        for (Tag tag : tags) {
            tagIds.add(tag.getTagID());
        }
        return String.join((CharSequence)", ", tagIds);
    }
}

