/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.service;

import de.valtech.aecu.api.service.ExecutionResult;
import de.valtech.aecu.api.service.ExecutionState;
import de.valtech.aecu.api.service.HistoryEntry;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class HistoryEntryImpl
implements HistoryEntry {
    private HistoryEntry.STATE state;
    private String path;
    private Date start;
    private Date end;
    private List<ExecutionResult> singleResults = new ArrayList<ExecutionResult>();

    public Date getStart() {
        return (Date)this.start.clone();
    }

    public Date getEnd() {
        return (Date)this.end.clone();
    }

    public List<ExecutionResult> getSingleResults() {
        return new ArrayList<ExecutionResult>(this.singleResults);
    }

    public void addSingleResult(ExecutionResult result) {
        this.singleResults.add(result);
    }

    public HistoryEntry.STATE getState() {
        return this.state;
    }

    public HistoryEntry.RESULT getResult() {
        if (this.singleResults.isEmpty()) {
            return HistoryEntry.RESULT.UNKNOWN;
        }
        HistoryEntry.RESULT result = HistoryEntry.RESULT.SUCCESS;
        for (ExecutionResult singleResult : this.singleResults) {
            if (!ExecutionState.FAILED.equals((Object)singleResult.getState())) continue;
            result = HistoryEntry.RESULT.FAILURE;
            break;
        }
        return result;
    }

    public String getRepositoryPath() {
        return this.path;
    }

    public void setStart(Date start) {
        this.start = (Date)start.clone();
    }

    public void setEnd(Date end) {
        this.end = (Date)end.clone();
    }

    public void setRepositoryPath(String path) {
        this.path = path;
    }

    public void setState(HistoryEntry.STATE state) {
        this.state = state;
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        output.append("Path: " + this.getRepositoryPath() + "\n");
        output.append("Start: " + this.getStart() + "\n");
        output.append("End: " + this.getEnd() + "\n");
        output.append("State: " + this.getState() + "\n");
        output.append("Result: " + this.getResult() + "\n\n");
        for (ExecutionResult singleResult : this.singleResults) {
            output.append(singleResult.toString() + "\n");
        }
        return output.toString();
    }
}

