/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.properties;

import com.day.cq.commons.jcr.JcrUtil;
import de.valtech.aecu.api.groovy.console.bindings.GStringConverter;
import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;

public class SetProperty
implements Action {
    protected String name;
    protected Object value;
    private String subNodePath;
    private String primaryType;

    public SetProperty(@Nonnull String name, Object value, String subNodePath, String primaryType) {
        this.name = name;
        this.value = GStringConverter.convert((Object)value);
        this.subNodePath = subNodePath;
        this.primaryType = primaryType;
    }

    @Override
    public String doAction(@Nonnull Resource resource) {
        ModifiableValueMap properties;
        Resource operatingResource = resource;
        if (this.subNodePath != null && (operatingResource = resource.getChild(this.subNodePath)) == null) {
            Session session = (Session)resource.getResourceResolver().adaptTo(Session.class);
            String finalPath = resource.getPath() + "/" + this.subNodePath;
            try {
                JcrUtil.createPath((String)finalPath, (String)this.primaryType, (Session)session);
                operatingResource = resource.getResourceResolver().getResource(finalPath);
            }
            catch (RepositoryException e) {
                return "Unable to create " + finalPath + ". " + e.getMessage();
            }
        }
        if ((properties = (ModifiableValueMap)operatingResource.adaptTo(ModifiableValueMap.class)) != null) {
            properties.put((Object)this.name, this.value);
            return "Setting " + this.value.getClass().getSimpleName() + " property " + this.name + "=" + this.value + " for resource " + operatingResource.getPath();
        }
        return "WARNING: could not get ModifiableValueMap for resource " + operatingResource.getPath();
    }
}

