/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.accessrights.validators.page;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.WCMException;
import de.valtech.aecu.api.groovy.console.bindings.accessrights.ValidationResult;
import de.valtech.aecu.core.groovy.console.bindings.accessrights.AccessValidatorContext;
import de.valtech.aecu.core.groovy.console.bindings.accessrights.validators.resource.CreateAccessValidator;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.sling.api.resource.Resource;

public class CreatePageAccessValidator
extends CreateAccessValidator {
    private String templatePath;

    public CreatePageAccessValidator(Group group, Resource resource, AccessValidatorContext context, boolean checkAccessGranted, String templatePath) {
        super(group, resource, context, checkAccessGranted);
        this.templatePath = templatePath;
    }

    @Override
    public ValidationResult validate(boolean simulate) {
        ValidationResult resourceResult = super.validate(simulate);
        if (!resourceResult.isSuccessful() && this.getCheckAccessGranted()) {
            return resourceResult;
        }
        if (!this.pageExists()) {
            return new ValidationResult(false, true, "Page not found");
        }
        return this.canCreatePageWithUser();
    }

    private boolean pageExists() {
        Page page = this.getContext().getAdminPageManager().getPage(this.getResource().getPath());
        return page != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationResult canCreatePageWithUser() {
        AccessValidatorContext.TestUser testUser = this.getContext().getTestUserForGroup(this.group);
        if (testUser == null) {
            return new ValidationResult(true, false, "Unable to create test user");
        }
        PageManager userPageManager = (PageManager)testUser.getResolver().adaptTo(PageManager.class);
        Page page = userPageManager.getPage(this.getResource().getPath());
        try {
            Page subpage = userPageManager.create(page.getPath(), "aecu-testpage", this.templatePath, "AECU Test", false);
            Template template = subpage.getTemplate();
            if (template == null) {
                ValidationResult validationResult = new ValidationResult(this.getCheckAccessGranted(), false, "Cannot read template");
                return validationResult;
            }
            if (!template.isAllowed(page.getPath())) {
                ValidationResult validationResult = new ValidationResult(this.getCheckAccessGranted(), false, "Template not allowed at this location");
                return validationResult;
            }
        }
        catch (WCMException e) {
            ValidationResult validationResult = new ValidationResult(this.getCheckAccessGranted(), false, e.getMessage());
            return validationResult;
        }
        finally {
            testUser.getResolver().revert();
            testUser.getResolver().refresh();
        }
        return new ValidationResult(!this.getCheckAccessGranted(), false, "Wrong permissions");
    }

    @Override
    public String getLabel() {
        return this.getCheckAccessGranted() ? "Create Page" : "Cannot Create Page";
    }
}

