/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.service;

import de.valtech.aecu.api.service.AecuException;
import de.valtech.aecu.api.service.AecuService;
import de.valtech.aecu.core.groovy.console.bindings.provider.AecuBindingExtensionProvider;
import de.valtech.aecu.core.groovy.console.bindings.provider.AecuStarImportExtensionProvider;
import de.valtech.aecu.core.serviceuser.ServiceResourceResolverService;
import de.valtech.aecu.core.util.runtime.RuntimeHelper;
import javax.jcr.Session;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AecuCloudStartupService.class}, immediate=true, name="AECU cloud startup hook")
public class AecuCloudStartupService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AecuCloudStartupService.class);
    @Reference
    private AecuService aecuService;
    @Reference
    private ServiceResourceResolverService resourceResolverService;
    @Reference
    private AecuBindingExtensionProvider dependency1;
    @Reference
    private AecuStarImportExtensionProvider dependency2;

    @Activate
    public void activate() {
        ResourceResolver resourceResolver = this.getResourceResolver();
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        boolean isCompositeNodeStore = RuntimeHelper.isCompositeNodeStore(session);
        if (isCompositeNodeStore) {
            this.startAecuMigration();
        }
    }

    void startAecuMigration() {
        try {
            LOGGER.info("AECU migration started");
            this.aecuService.executeWithInstallHookHistory("/apps/aecu-scripts");
            LOGGER.info("AECU migration finished");
        }
        catch (AecuException ae) {
            LOGGER.error("Error while executing AECU migration", (Throwable)ae);
        }
    }

    private ResourceResolver getResourceResolver() {
        try {
            return this.resourceResolverService.getAdminResourceResolver();
        }
        catch (LoginException le) {
            throw new IllegalStateException("Error while logging in", le);
        }
    }
}

