/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.page;

import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.Page;
import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import de.valtech.aecu.core.groovy.console.bindings.impl.BindingContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;

public class AddPageTagsAction
implements Action {
    private BindingContext context;
    private String[] tags;

    public AddPageTagsAction(BindingContext context, String ... tags) {
        this.context = context;
        this.tags = (String[])tags.clone();
    }

    @Override
    public String doAction(Resource resource) throws PersistenceException {
        Page page = this.context.getPageManager().getContainingPage(resource);
        if (page == null) {
            return "Unable to find a page for resource " + resource.getPath();
        }
        Tag[] oldTags = page.getTags();
        List<Tag> tagsToAdd = this.getTagsToAdd(oldTags);
        if (tagsToAdd.isEmpty()) {
            return "No missing tags to add";
        }
        String successMessage = "Added page tags on " + page.getPath() + ": " + this.getTagListAsString(tagsToAdd);
        if (this.context.isDryRun()) {
            return successMessage;
        }
        TagManager tagManager = this.context.getTagManager();
        ArrayList<Tag> tagsToSet = new ArrayList<Tag>(tagsToAdd);
        tagsToSet.addAll(Arrays.asList(oldTags));
        tagManager.setTags(page.getContentResource(), tagsToSet.toArray(new Tag[tagsToSet.size()]));
        return successMessage;
    }

    private List<Tag> getTagsToAdd(Tag[] oldTags) throws PersistenceException {
        HashSet<String> oldTagPaths = new HashSet<String>();
        for (Tag oldTag : oldTags) {
            oldTagPaths.add(oldTag.getPath());
        }
        TagManager tagManager = this.context.getTagManager();
        ArrayList<Tag> toAdd = new ArrayList<Tag>();
        for (String newTagName : this.tags) {
            Tag tag = tagManager.resolve(newTagName);
            if (tag == null) {
                throw new PersistenceException("Tag " + newTagName + " does not exist.\n");
            }
            if (oldTagPaths.contains(tag.getPath())) continue;
            toAdd.add(tag);
        }
        return toAdd;
    }

    private String getTagListAsString(List<Tag> tags) {
        ArrayList<String> tagIds = new ArrayList<String>();
        for (Tag tag : tags) {
            tagIds.add(tag.getTagID());
        }
        return String.join((CharSequence)", ", tagIds);
    }
}

