/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.serviceuser;

import java.util.HashMap;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ServiceResourceResolverService.class})
public class ServiceResourceResolverService {
    private static final String SUBSERVICE_AECU = "aecu";
    private static final String SUBSERVICE_AECU_ADMIN = "aecu-admin";
    private static final String SUBSERVICE_AECU_CONTENT_MIGRATION = "aecu-content-migrator";
    @Reference
    ResourceResolverFactory resolverFactory;

    public ResourceResolver getServiceResourceResolver() throws LoginException {
        HashMap<String, String> authenticationInfo = new HashMap<String, String>();
        authenticationInfo.put("sling.service.subservice", SUBSERVICE_AECU);
        return this.resolverFactory.getServiceResourceResolver(authenticationInfo);
    }

    public ResourceResolver getContentMigratorResourceResolver() throws LoginException {
        HashMap<String, String> authenticationInfo = new HashMap<String, String>();
        authenticationInfo.put("sling.service.subservice", SUBSERVICE_AECU_CONTENT_MIGRATION);
        return this.resolverFactory.getServiceResourceResolver(authenticationInfo);
    }

    public ResourceResolver getAdminResourceResolver() throws LoginException {
        HashMap<String, String> authenticationInfo = new HashMap<String, String>();
        authenticationInfo.put("sling.service.subservice", SUBSERVICE_AECU_ADMIN);
        return this.resolverFactory.getServiceResourceResolver(authenticationInfo);
    }
}

