/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.service;

import com.icfolson.aem.groovy.console.GroovyConsoleService;
import com.icfolson.aem.groovy.console.api.context.ScriptContext;
import com.icfolson.aem.groovy.console.response.RunScriptResponse;
import de.valtech.aecu.api.service.AecuException;
import de.valtech.aecu.api.service.AecuService;
import de.valtech.aecu.api.service.ExecutionResult;
import de.valtech.aecu.api.service.ExecutionState;
import de.valtech.aecu.api.service.HistoryEntry;
import de.valtech.aecu.core.history.HistoryUtil;
import de.valtech.aecu.core.service.AecuScriptContext;
import de.valtech.aecu.core.serviceuser.ServiceResourceResolverService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AecuService.class})
public class AecuServiceImpl
implements AecuService {
    private static final String PRECHECKS_SELECTOR = ".prechecks.";
    private static final String FALLBACK_SELECTOR = ".fallback.";
    private static final String ERR_NO_RESOLVER = "Unable to get service resource resolver";
    protected static final String DIR_FALLBACK_SCRIPT = "fallback.groovy";
    protected static final String DIR_PRECHECKS_SCRIPT = "prechecks.groovy";
    private static final Logger LOG = LoggerFactory.getLogger(AecuServiceImpl.class);
    @Reference
    private ServiceResourceResolverService resolverService;
    @Reference
    private SlingSettingsService slingSettings;
    @Reference
    private GroovyConsoleService groovyConsoleService;
    @Reference
    private HistoryUtil historyUtil;

    public String getVersion() {
        return FrameworkUtil.getBundle(AecuServiceImpl.class).getVersion().toString();
    }

    public List<String> getFiles(String path) throws AecuException {
        List<String> list;
        block8: {
            ResourceResolver resolver = this.resolverService.getServiceResourceResolver();
            try {
                list = this.findCandidates(resolver, path);
                if (resolver == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resolver != null) {
                        try {
                            resolver.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LoginException e) {
                    throw new AecuException(ERR_NO_RESOLVER, (Throwable)e);
                }
            }
            resolver.close();
        }
        return list;
    }

    private List<String> findCandidates(ResourceResolver resolver, String path) throws AecuException {
        if (path == null) {
            throw new AecuException("Path is null");
        }
        Resource resource = resolver.getResource(path);
        if (resource == null) {
            throw new AecuException("Path is invalid");
        }
        ArrayList<String> candidates = new ArrayList<String>();
        if (this.isFolder(resource) && this.matchesRunmodes(resource.getName())) {
            ArrayList<String> childNames = new ArrayList<String>();
            for (Resource child : resource.getChildren()) {
                childNames.add(child.getName());
            }
            childNames.sort(null);
            for (String childName : childNames) {
                candidates.addAll(this.findCandidates(resolver, resource.getChild(childName).getPath()));
            }
        } else if (this.isValidScriptName(resource.getName())) {
            candidates.add(path);
        }
        return candidates;
    }

    private boolean isFolder(Resource resource) {
        String type = (String)resource.getValueMap().get("jcr:primaryType", String.class);
        return "sling:Folder".equals(type) || "sling:OrderedFolder".equals(type) || "nt:folder".equals(type);
    }

    public boolean matchesRunmodes(String name) {
        String[] combinations;
        if (!name.contains(".")) {
            return true;
        }
        Set runModes = this.slingSettings.getRunModes();
        String runModeString = name.substring(name.indexOf(46) + 1);
        for (String combination : combinations = runModeString.split(";")) {
            String[] modes = combination.split("\\.");
            if (!runModes.containsAll(Arrays.asList(modes))) continue;
            return true;
        }
        return false;
    }

    public boolean isValidScriptName(String name) {
        if (!name.endsWith(".groovy")) {
            return false;
        }
        return !name.contains(FALLBACK_SELECTOR) && !DIR_FALLBACK_SCRIPT.equals(name) && !name.contains(PRECHECKS_SELECTOR) && !DIR_PRECHECKS_SCRIPT.equals(name);
    }

    public ExecutionResult execute(String path) throws AecuException {
        ExecutionResult executionResult;
        block10: {
            ResourceResolver resolver = this.resolverService.getContentMigratorResourceResolver();
            try {
                Resource resource = resolver.getResource(path);
                if (resource == null) {
                    throw new AecuException("Path is invalid");
                }
                if (!this.isValidScriptName(resource.getName())) {
                    throw new AecuException("Invalid script name");
                }
                executionResult = this.executeScript(resolver, path);
                if (resolver == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (resolver != null) {
                        try {
                            resolver.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LoginException e) {
                    throw new AecuException(ERR_NO_RESOLVER, (Throwable)e);
                }
            }
            resolver.close();
        }
        return executionResult;
    }

    private ExecutionResult executeScript(ResourceResolver resolver, String path) throws AecuException {
        ExecutionResult prechecksResult;
        LOG.info("Executing script {}", (Object)path);
        String prechecksScript = this.getPrechecksScript(resolver, path);
        if (prechecksScript != null && (prechecksResult = this.executeScript(resolver, prechecksScript)).getState() == ExecutionState.FAILED) {
            LOG.info("Skipping {} as prechecks script failed", (Object)path);
            return new ExecutionResult(ExecutionState.SKIPPED, prechecksResult.getTime(), prechecksResult.getResult(), prechecksResult.getOutput(), null, path);
        }
        AecuScriptContext scriptContext = new AecuScriptContext(this.loadScript(path, resolver), resolver);
        RunScriptResponse response = this.groovyConsoleService.runScript((ScriptContext)scriptContext);
        boolean success = StringUtils.isBlank((CharSequence)response.getExceptionStackTrace());
        if (success) {
            LOG.info("Executed script {} with status OK", (Object)path);
        } else {
            LOG.error("Executed script {} with status FAILED", (Object)path);
        }
        String result = response.getResult();
        ExecutionResult fallbackResult = null;
        if (!success && this.getFallbackScript(resolver, path) != null) {
            fallbackResult = this.executeScript(resolver, this.getFallbackScript(resolver, path));
        }
        ExecutionState state = success ? ExecutionState.SUCCESS : ExecutionState.FAILED;
        return new ExecutionResult(state, response.getRunningTime(), result, response.getOutput() + response.getExceptionStackTrace(), fallbackResult, path);
    }

    private String loadScript(String path, ResourceResolver resolver) throws AecuException {
        String string;
        block9: {
            Resource resource = resolver.getResource(path + "/" + "jcr:content");
            InputStream inputStream = (InputStream)resource.adaptTo(InputStream.class);
            try {
                if (inputStream == null) {
                    throw new IOException("Resource at '" + path + "' cannot be adapted to InputStream, it doesn't seem to contain binary data");
                }
                string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AecuException("Unable to read script", (Throwable)e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    protected String getFallbackScript(ResourceResolver resolver, String path) {
        String name = path.substring(path.lastIndexOf(47) + 1);
        if (name.contains(FALLBACK_SELECTOR) || DIR_FALLBACK_SCRIPT.equals(name)) {
            return null;
        }
        String baseName = name.substring(0, name.indexOf(46));
        String fallbackPath = path.substring(0, path.lastIndexOf(47) + 1) + baseName + FALLBACK_SELECTOR + "groovy";
        if (resolver.getResource(fallbackPath) != null) {
            return fallbackPath;
        }
        String directoryFallbackPath = path.substring(0, path.lastIndexOf(47) + 1) + DIR_FALLBACK_SCRIPT;
        if (resolver.getResource(directoryFallbackPath) != null) {
            return directoryFallbackPath;
        }
        return null;
    }

    protected String getPrechecksScript(ResourceResolver resolver, String path) {
        String name = path.substring(path.lastIndexOf(47) + 1);
        if (name.contains(PRECHECKS_SELECTOR) || DIR_PRECHECKS_SCRIPT.equals(name)) {
            return null;
        }
        String baseName = name.substring(0, name.indexOf(46));
        String prechecksPath = path.substring(0, path.lastIndexOf(47) + 1) + baseName + PRECHECKS_SELECTOR + "groovy";
        if (resolver.getResource(prechecksPath) != null) {
            return prechecksPath;
        }
        String directoryPrechecksPath = path.substring(0, path.lastIndexOf(47) + 1) + DIR_PRECHECKS_SCRIPT;
        if (resolver.getResource(directoryPrechecksPath) != null) {
            return directoryPrechecksPath;
        }
        return null;
    }

    public HistoryEntry createHistoryEntry() throws AecuException {
        HistoryEntry historyEntry;
        block9: {
            ResourceResolver resolver = this.resolverService.getServiceResourceResolver();
            try {
                HistoryEntry entry = this.historyUtil.createHistoryEntry(resolver);
                resolver.commit();
                historyEntry = entry;
                if (resolver == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resolver != null) {
                        try {
                            resolver.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PersistenceException e) {
                    throw new AecuException("Unable to create history", (Throwable)e);
                }
                catch (LoginException e) {
                    throw new AecuException(ERR_NO_RESOLVER, (Throwable)e);
                }
            }
            resolver.close();
        }
        return historyEntry;
    }

    public HistoryEntry finishHistoryEntry(HistoryEntry history) throws AecuException {
        HistoryEntry historyEntry;
        block9: {
            ResourceResolver resolver = this.resolverService.getServiceResourceResolver();
            try {
                this.historyUtil.finishHistoryEntry(history, resolver);
                resolver.commit();
                historyEntry = history;
                if (resolver == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resolver != null) {
                        try {
                            resolver.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LoginException e) {
                    throw new AecuException(ERR_NO_RESOLVER, (Throwable)e);
                }
                catch (PersistenceException e) {
                    throw new AecuException("Unable to finish history " + history.getRepositoryPath(), (Throwable)e);
                }
            }
            resolver.close();
        }
        return historyEntry;
    }

    public HistoryEntry storeExecutionInHistory(HistoryEntry history, ExecutionResult result) throws AecuException {
        HistoryEntry historyEntry;
        block10: {
            if (history == null || !HistoryEntry.STATE.RUNNING.equals((Object)history.getState())) {
                throw new AecuException("Invalid history entry.");
            }
            history.getSingleResults().add(result);
            ResourceResolver resolver = this.resolverService.getServiceResourceResolver();
            try {
                this.historyUtil.storeExecutionInHistory(history, result, resolver);
                resolver.commit();
                historyEntry = history;
                if (resolver == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (resolver != null) {
                        try {
                            resolver.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LoginException e) {
                    throw new AecuException(ERR_NO_RESOLVER, (Throwable)e);
                }
                catch (PersistenceException e) {
                    throw new AecuException("Unable to add history entry " + history.getRepositoryPath(), (Throwable)e);
                }
            }
            resolver.close();
        }
        return historyEntry;
    }

    public List<HistoryEntry> getHistory(int startIndex, int count) throws AecuException {
        List<HistoryEntry> list;
        block8: {
            ResourceResolver resolver = this.resolverService.getServiceResourceResolver();
            try {
                list = this.historyUtil.getHistory(startIndex, count, resolver);
                if (resolver == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resolver != null) {
                        try {
                            resolver.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LoginException e) {
                    throw new AecuException(ERR_NO_RESOLVER, (Throwable)e);
                }
            }
            resolver.close();
        }
        return list;
    }
}

