/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.installhook;

import de.valtech.aecu.api.service.AecuException;
import de.valtech.aecu.api.service.AecuService;
import de.valtech.aecu.api.service.ExecutionResult;
import de.valtech.aecu.api.service.ExecutionState;
import de.valtech.aecu.api.service.HistoryEntry;
import de.valtech.aecu.core.installhook.AecuTrackerListener;
import de.valtech.aecu.core.installhook.HookExecutionHistory;
import de.valtech.aecu.core.installhook.OsgiServiceProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.packaging.InstallContext;
import org.apache.jackrabbit.vault.packaging.InstallHook;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AecuInstallHook
implements InstallHook {
    private static final Logger LOG = LoggerFactory.getLogger(AecuInstallHook.class);
    private final OsgiServiceProvider osgiServiceProvider = new OsgiServiceProvider(this.getClass());
    private AecuTrackerListener listener;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(InstallContext installContext) throws PackageException {
        LOG.info("Executing in phase {}", (Object)installContext.getPhase());
        ServiceReference<AecuService> aecuServiceReference = this.osgiServiceProvider.getServiceReference(AecuService.class);
        AecuService aecuService = this.osgiServiceProvider.getService(aecuServiceReference);
        try {
            switch (installContext.getPhase()) {
                case PREPARE: {
                    ProgressTrackerListener originalListener = installContext.getOptions().getListener();
                    this.listener = new AecuTrackerListener(originalListener, aecuService);
                    installContext.getOptions().setListener((ProgressTrackerListener)this.listener);
                    return;
                }
                case INSTALLED: {
                    Archive archive = installContext.getPackage().getArchive();
                    List<String> allValidScriptCandidatesInArchive = this.findCandidates("", archive.getJcrRoot(), aecuService);
                    List<String> scriptsForInstallation = this.getScriptsForExecution(allValidScriptCandidatesInArchive, installContext);
                    if (scriptsForInstallation.isEmpty()) return;
                    HistoryEntry installationHistory = this.executeScripts(scriptsForInstallation, aecuService, installContext);
                    if (HistoryEntry.RESULT.SUCCESS.equals((Object)installationHistory.getResult())) return;
                    throw new PackageException("Failed installation, check installation history at " + installationHistory.getRepositoryPath());
                }
            }
            return;
        }
        catch (AecuException | IOException e) {
            throw new PackageException(e);
        }
        finally {
            this.osgiServiceProvider.ungetService(aecuServiceReference);
        }
    }

    private List<String> getScriptsForExecution(List<String> allValidScriptCandidatesInArchive, InstallContext installContext) {
        ArrayList<String> scriptsForExecution = new ArrayList<String>();
        List<String> modifiedOrAddedScriptPaths = this.listener.getModifiedOrAddedPaths();
        for (String groovyScriptPath : allValidScriptCandidatesInArchive) {
            try {
                HookExecutionHistory hookExecutionHistory = new HookExecutionHistory(installContext.getSession(), groovyScriptPath);
                if (!this.shouldExecute(modifiedOrAddedScriptPaths, groovyScriptPath, hookExecutionHistory)) continue;
                scriptsForExecution.add(groovyScriptPath);
            }
            catch (AecuException e) {
                this.listener.logError("Could not obtain execution history for " + groovyScriptPath, (Exception)((Object)e));
            }
        }
        return scriptsForExecution;
    }

    private boolean shouldExecute(List<String> modifiedOrAddedScriptPaths, String groovyScriptPath, HookExecutionHistory hookExecutionHistory) {
        if (modifiedOrAddedScriptPaths.contains(groovyScriptPath)) {
            return true;
        }
        boolean wasNotYetExecuted = this.wasNotExecuted(groovyScriptPath, hookExecutionHistory);
        if (wasNotYetExecuted) {
            this.listener.logMessage("Force executing as not yet run:" + groovyScriptPath);
        }
        return wasNotYetExecuted;
    }

    private boolean wasNotExecuted(String path, HookExecutionHistory history) {
        return !history.hasBeenExecutedBefore() && (path.startsWith("/var/groovyconsole/scripts/aecu") || path.startsWith("/conf/groovyconsole/scripts/aecu"));
    }

    private HistoryEntry executeScripts(List<String> scriptsForExecution, AecuService aecuService, InstallContext installContext) throws AecuException, IOException {
        HistoryEntry installationHistory = aecuService.createHistoryEntry();
        boolean stopExecution = false;
        for (String groovyScriptPath : scriptsForExecution) {
            HookExecutionHistory hookExecutionHistory = new HookExecutionHistory(installContext.getSession(), groovyScriptPath);
            try {
                if (!stopExecution) {
                    if (HistoryEntry.RESULT.FAILURE.equals((Object)(installationHistory = this.executeScript(aecuService, installationHistory, groovyScriptPath)).getResult())) {
                        stopExecution = true;
                        continue;
                    }
                    hookExecutionHistory.setExecuted();
                    continue;
                }
                installationHistory = this.skipScript(aecuService, installationHistory, groovyScriptPath);
            }
            catch (AecuException e) {
                this.listener.logError("Error executing script " + groovyScriptPath, (Exception)((Object)e));
            }
        }
        installationHistory = aecuService.finishHistoryEntry(installationHistory);
        return installationHistory;
    }

    private HistoryEntry skipScript(AecuService aecuService, HistoryEntry installationHistory, String groovyScriptPath) throws AecuException {
        this.listener.logMessage("Skipping script because of previous error " + groovyScriptPath);
        ExecutionResult result = new ExecutionResult(ExecutionState.SKIPPED, null, null, null, null, groovyScriptPath);
        installationHistory = aecuService.storeExecutionInHistory(installationHistory, result);
        return installationHistory;
    }

    private HistoryEntry executeScript(AecuService aecuService, HistoryEntry installationHistory, String groovyScriptPath) throws AecuException {
        this.listener.logMessage("Executing script " + groovyScriptPath);
        ExecutionResult result = aecuService.execute(groovyScriptPath);
        installationHistory = aecuService.storeExecutionInHistory(installationHistory, result);
        this.listener.logMessage("Executed script " + groovyScriptPath + ", output: \n" + result.getOutput());
        return installationHistory;
    }

    private List<String> findCandidates(String parent, Archive.Entry entry, AecuService aecuService) {
        ArrayList<String> candidates = new ArrayList<String>();
        if (entry == null) {
            return candidates;
        }
        String entryName = entry.getName();
        String entryPath = parent + "/" + entryName;
        if (entry.isDirectory() && aecuService.matchesRunmodes(entryName)) {
            ArrayList<String> childNames = new ArrayList<String>();
            for (Archive.Entry child : entry.getChildren()) {
                childNames.add(child.getName());
            }
            childNames.sort(null);
            for (String childName : childNames) {
                Archive.Entry childEntry = entry.getChild(childName);
                candidates.addAll(this.findCandidates(entryPath, childEntry, aecuService));
            }
        } else if (aecuService.isValidScriptName(entryName)) {
            candidates.add(StringUtils.substringAfter((String)entryPath, (String)"/jcr_root"));
        }
        return candidates;
    }
}

