/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.resource;

import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import de.valtech.aecu.core.groovy.console.bindings.actions.util.PageUtil;
import de.valtech.aecu.core.groovy.console.bindings.impl.BindingContext;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class MoveResourceToPathRegex
implements Action {
    private BindingContext context;
    private String matchPattern;
    private String targetPathExpr;

    public MoveResourceToPathRegex(@Nonnull String matchPattern, @Nonnull String targetPathExpr, @Nonnull BindingContext context) {
        this.context = context;
        this.matchPattern = matchPattern;
        this.targetPathExpr = targetPathExpr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String doAction(@Nonnull Resource resource) throws PersistenceException {
        ResourceResolver resourceResolver = this.context.getResolver();
        String resourcePath = resource.getPath();
        if (!resourcePath.matches(this.matchPattern)) return "INFO: resource " + resourcePath + " does not match path regex " + this.matchPattern + ", skipping";
        String targetPath = resourcePath.replaceAll(this.matchPattern, this.targetPathExpr);
        Resource destinationResource = resourceResolver.getResource(targetPath);
        if (destinationResource == null) return "WARNING: could not read move destination resource " + targetPath;
        PageUtil pageUtil = new PageUtil();
        if (pageUtil.isPageResource(resource)) {
            PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
            try {
                if (this.context.isDryRun()) return "Moved " + resourcePath + " to path " + targetPath;
                pageManager.move(resource, targetPath + "/" + resource.getName(), null, false, false, null);
                return "Moved " + resourcePath + " to path " + targetPath;
            }
            catch (WCMException | IllegalArgumentException e) {
                throw new PersistenceException("Unable to move " + resourcePath + ": " + e.getMessage());
            }
        } else {
            resourceResolver.move(resourcePath, targetPath);
        }
        return "Moved " + resourcePath + " to path " + targetPath;
    }
}

