/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.page;

import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.Page;
import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import de.valtech.aecu.core.groovy.console.bindings.impl.BindingContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;

public class RemovePageTagsAction
implements Action {
    private BindingContext context;
    private String[] tags;

    public RemovePageTagsAction(BindingContext context, String ... tags) {
        this.context = context;
        this.tags = tags;
    }

    @Override
    public String doAction(Resource resource) throws PersistenceException {
        Page page = this.context.getPageManager().getContainingPage(resource);
        if (page == null) {
            return "Unable to find a page for resource " + resource.getPath();
        }
        Tag[] oldTags = page.getTags();
        List<Tag> tagsToSet = this.getTagsToSet(oldTags);
        String successMessage = "Set page tags on " + page.getPath() + ": " + this.getTagListAsString(tagsToSet);
        if (this.context.isDryRun()) {
            return successMessage;
        }
        TagManager tagManager = this.context.getTagManager();
        tagManager.setTags(page.getContentResource(), tagsToSet.toArray(new Tag[tagsToSet.size()]));
        return successMessage;
    }

    private List<Tag> getTagsToSet(Tag[] oldTags) throws PersistenceException {
        ArrayList<Tag> tagsToSet = new ArrayList<Tag>();
        HashSet<String> pathsToDelete = new HashSet<String>();
        TagManager tagManager = this.context.getTagManager();
        for (String string : this.tags) {
            Tag tag = tagManager.resolve(string);
            if (tag == null) {
                throw new PersistenceException("Tag " + string + " does not exist.\n");
            }
            pathsToDelete.add(tag.getPath());
        }
        for (String string : oldTags) {
            if (pathsToDelete.contains(string.getPath())) continue;
            tagsToSet.add((Tag)string);
        }
        return tagsToSet;
    }

    private String getTagListAsString(List<Tag> tags) {
        ArrayList<String> tagIds = new ArrayList<String>();
        for (Tag tag : tags) {
            tagIds.add(tag.getTagID());
        }
        return String.join((CharSequence)", ", tagIds);
    }
}

