/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.accessrights.validators.page;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import de.valtech.aecu.api.groovy.console.bindings.accessrights.ValidationResult;
import de.valtech.aecu.core.groovy.console.bindings.accessrights.AccessValidatorContext;
import de.valtech.aecu.core.groovy.console.bindings.accessrights.validators.resource.DeleteAccessValidator;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.sling.api.resource.Resource;

public class DeletePageAccessValidator
extends DeleteAccessValidator {
    public DeletePageAccessValidator(Group group, Resource resource, AccessValidatorContext context, boolean checkAccessGranted) {
        super(group, resource, context, checkAccessGranted);
    }

    @Override
    public ValidationResult validate(boolean simulate) {
        ValidationResult resourceResult = super.validate(simulate);
        if (!resourceResult.isSuccessful()) {
            return resourceResult;
        }
        if (!this.pageExists()) {
            return new ValidationResult(false, true, "Page not found");
        }
        return this.canDeletePageWithUser();
    }

    private boolean pageExists() {
        Page page = this.getContext().getAdminPageManager().getPage(this.getResource().getPath());
        return page != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationResult canDeletePageWithUser() {
        AccessValidatorContext.TestUser testUser = this.getContext().getTestUserForGroup(this.group);
        if (testUser == null) {
            return new ValidationResult(true, false, "Unable to create test user");
        }
        PageManager userPageManager = (PageManager)testUser.getResolver().adaptTo(PageManager.class);
        Page page = userPageManager.getPage(this.getResource().getPath());
        try {
            userPageManager.delete(page, false, false);
        }
        catch (WCMException e) {
            ValidationResult validationResult = new ValidationResult(this.getCheckAccessGranted(), false, e.getMessage());
            return validationResult;
        }
        finally {
            testUser.getResolver().revert();
            testUser.getResolver().refresh();
        }
        return new ValidationResult(!this.getCheckAccessGranted(), false, "Wrong permissions");
    }

    @Override
    public String getLabel() {
        return this.getCheckAccessGranted() ? "Delete Page" : "Cannot Delete Page";
    }
}

