/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.accessrights;

import com.day.cq.replication.Replicator;
import com.day.cq.security.util.CqActions;
import com.day.cq.wcm.api.PageManager;
import java.security.Principal;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessValidatorContext {
    private static final Logger LOG = LoggerFactory.getLogger(AccessValidatorContext.class);
    private ResourceResolverFactory resourceResolverFactory;
    private ResourceResolver adminResolver;
    private Session adminSession;
    private CqActions cqActions;
    private PageManager adminPageManager;
    private UserManager adminUserManager;
    private Replicator replicator;
    private Map<String, Set<Principal>> principalCache = new HashMap<String, Set<Principal>>();
    private Map<Group, TestUser> testUsers = new HashMap<Group, TestUser>();

    public AccessValidatorContext(ResourceResolverFactory resourceResolverFactory, ResourceResolver adminResolver, Replicator replicator) throws RepositoryException {
        this.resourceResolverFactory = resourceResolverFactory;
        this.adminResolver = adminResolver;
        this.adminSession = (Session)adminResolver.adaptTo(Session.class);
        this.cqActions = new CqActions(this.adminSession);
        this.adminPageManager = (PageManager)adminResolver.adaptTo(PageManager.class);
        this.adminUserManager = (UserManager)adminResolver.adaptTo(UserManager.class);
        this.replicator = replicator;
    }

    public ResourceResolver getAdminResolver() {
        return this.adminResolver;
    }

    public Session getAdminSession() {
        return this.adminSession;
    }

    public CqActions getCqActions() {
        return this.cqActions;
    }

    public PageManager getAdminPageManager() {
        return this.adminPageManager;
    }

    public Replicator getReplicator() {
        return this.replicator;
    }

    public Set<Principal> getPrincipals(Authorizable authorizable) {
        HashSet<Principal> principals = new HashSet<Principal>();
        try {
            String authorizableId = authorizable.getID();
            if (this.principalCache.containsKey(authorizableId)) {
                return this.principalCache.get(authorizableId);
            }
            Principal principal = authorizable.getPrincipal();
            principals.add(principal);
            PrincipalIterator it = ((JackrabbitSession)this.getAdminSession()).getPrincipalManager().getGroupMembership(principal);
            while (it.hasNext()) {
                principals.add(it.nextPrincipal());
            }
            this.principalCache.put(authorizableId, principals);
        }
        catch (RepositoryException e) {
            LOG.error("Error resolving principals", (Throwable)e);
        }
        return principals;
    }

    public TestUser getTestUserForGroup(Group group) {
        if (this.testUsers.containsKey(group)) {
            return this.testUsers.get(group);
        }
        try {
            String userId = this.generateUserId();
            String userPassword = this.generateUserPassword();
            User user = this.createTestUser(group, userId, userPassword);
            ResourceResolver userResourceResolver = this.login(userId, userPassword);
            TestUser testUser = new TestUser(user, group, userResourceResolver);
            this.testUsers.put(group, testUser);
            return testUser;
        }
        catch (RepositoryException | LoginException | PersistenceException e) {
            LOG.error("Unable to create temporary test user", e);
            return null;
        }
    }

    private String generateUserId() {
        SecureRandom random = new SecureRandom();
        return "aecu-testuser-" + System.currentTimeMillis() + "_" + random.nextLong();
    }

    private String generateUserPassword() {
        SecureRandom random = new SecureRandom();
        byte[] passwordBytes = new byte[10];
        random.nextBytes(passwordBytes);
        return System.currentTimeMillis() + "_" + Base64.getEncoder().encodeToString(passwordBytes);
    }

    private ResourceResolver login(String userId, String userPassword) throws LoginException {
        HashMap<String, Object> authInfo = new HashMap<String, Object>();
        authInfo.put("user.name", userId);
        authInfo.put("user.password", userPassword.toCharArray());
        return this.resourceResolverFactory.getResourceResolver(authInfo);
    }

    private User createTestUser(Group group, String userId, String password) throws RepositoryException, PersistenceException {
        User user = this.adminUserManager.createUser(userId, password);
        this.adminResolver.commit();
        group.addMember((Authorizable)user);
        this.adminResolver.commit();
        return user;
    }

    public void cleanup() {
        this.adminResolver.revert();
        for (TestUser testUser : this.testUsers.values()) {
            if (testUser.resolver != null) {
                testUser.resolver.revert();
                testUser.resolver.close();
            }
            try {
                this.adminResolver.refresh();
                testUser.group.removeMember((Authorizable)testUser.user);
                testUser.user.remove();
                this.adminResolver.commit();
            }
            catch (RepositoryException | PersistenceException e) {
                LOG.error("Unable to delete temporary user", e);
                this.adminResolver.revert();
            }
        }
    }

    public static class TestUser {
        private Group group;
        private User user;
        private ResourceResolver resolver;

        public TestUser(User user, Group group, ResourceResolver resolver) {
            this.user = user;
            this.group = group;
            this.resolver = resolver;
        }

        public Group getGroup() {
            return this.group;
        }

        public User getUser() {
            return this.user;
        }

        public ResourceResolver getResolver() {
            return this.resolver;
        }
    }
}

