/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.api.service;

import de.valtech.aecu.api.service.ExecutionState;
import org.apache.commons.lang3.StringUtils;

public class ExecutionResult {
    private ExecutionState state;
    private String output;
    private String time;
    private String result;
    private ExecutionResult fallbackResult;
    private String path;

    public ExecutionResult(ExecutionState state, String time, String result, String output, ExecutionResult fallbackResult, String path) {
        this.state = state;
        this.output = output;
        this.time = time;
        this.result = result;
        this.fallbackResult = fallbackResult;
        this.path = path;
    }

    public ExecutionState getState() {
        return this.state;
    }

    public String getResult() {
        return this.result;
    }

    public String getOutput() {
        return this.output;
    }

    public String getTime() {
        return this.time;
    }

    public ExecutionResult getFallbackResult() {
        return this.fallbackResult;
    }

    public String getPath() {
        return this.path;
    }

    public String getShortPath() {
        return this.path.replace("/etc/groovyconsole/scripts/aecu/", "");
    }

    public String toString() {
        StringBuilder stringVal = new StringBuilder("Successful: " + this.state.name() + "Path: " + this.path);
        if (StringUtils.isNotBlank((CharSequence)this.time)) {
            stringVal.append("\nExecution time: " + this.time);
        }
        if (StringUtils.isNotBlank((CharSequence)this.result)) {
            stringVal.append("\nResult: " + this.result);
        }
        stringVal.append("\nOutput: " + this.output);
        if (this.fallbackResult != null) {
            stringVal.append("Fallback script executed:\n" + this.fallbackResult.toString());
        }
        return stringVal.toString();
    }
}

