/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.api.groovy.console.bindings.filters;

import de.valtech.aecu.api.groovy.console.bindings.filters.FilterBy;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class FilterByPropertyRegex
implements FilterBy {
    private String name;
    private Pattern pattern;

    public FilterByPropertyRegex(String name, @Nonnull String regex) {
        this.name = name;
        this.pattern = Pattern.compile(regex);
    }

    @Override
    public boolean filter(@Nonnull Resource resource, StringBuffer stringBuffer) {
        ValueMap properties = resource.getValueMap();
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            String value = (String)properties.get(this.name, String.class);
            return value != null && this.pattern.matcher(value).matches();
        }
        for (String key : properties.keySet()) {
            String value = (String)properties.get(key, String.class);
            if (value == null || !this.pattern.matcher(value).matches()) continue;
            return true;
        }
        return false;
    }
}

