/*
 * Decompiled with CFR 0.152.
 */
package de.unruh.isabelle.misc;

import java.io.Serializable;
import java.nio.file.Path;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;
import scalaz.syntax.IdOps$;

public final class Utils$ {
    public static final Utils$ MODULE$ = new Utils$();
    private static final Logger logger = LoggerFactory.getLogger((String)"de.unruh.isabelle.misc.Utils");

    private Logger logger() {
        return logger;
    }

    public boolean checkEnvironmentFlag(String variable) {
        block10: {
            String content;
            String string;
            try {
                string = System.getenv(variable);
            }
            catch (SecurityException e) {
                if (this.logger().isDebugEnabled()) {
                    this.logger().debug(new StringBuilder(33).append("Cannot read environment variable ").append(variable).toString(), (Throwable)e);
                }
                string = content = null;
            }
            if (content == null) {
                return false;
            }
            String string2 = content.toLowerCase();
            switch (string2 == null ? 0 : string2.hashCode()) {
                case 49: {
                    if ("1".equals(string2)) {
                        break;
                    }
                    break block10;
                }
                case 3569038: {
                    if ("true".equals(string2)) {
                        break;
                    }
                    break block10;
                }
                default: {
                    break block10;
                }
            }
            return true;
        }
        return false;
    }

    public void destroyProcessThoroughly(Process process, ExecutionContext ec) {
        ProcessHandle processHandle = process.toHandle();
        List processes = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaIteratorConverter(process.descendants().iterator()).asScala()).toList().$colon$colon((Object)processHandle);
        processes.foreach((Function1 & Serializable)p -> {
            Boolean bl;
            try {
                bl = BoxesRunTime.boxToBoolean((boolean)p.destroy());
            }
            catch (Exception e) {
                e.printStackTrace();
                bl = BoxedUnit.UNIT;
            }
            return bl;
        });
        Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable)() -> Thread.sleep(1000L));
            processes.foreach((Function1 & Serializable)p -> {
                Boolean bl;
                try {
                    bl = BoxesRunTime.boxToBoolean((boolean)p.destroyForcibly());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    bl = BoxedUnit.UNIT;
                }
                return bl;
            });
        }, ec);
    }

    public String freshName(String name) {
        return (String)IdOps$.MODULE$.into$extension(scalaz.syntax.package$.MODULE$.id().ToIdOps(IdOps$.MODULE$.into$extension(scalaz.syntax.package$.MODULE$.id().ToIdOps((Object)StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(name), (Function1 & Serializable)c -> BoxesRunTime.boxToCharacter((char)Utils$.$anonfun$freshName$1(BoxesRunTime.unboxToChar((Object)c))))), (Function1 & Serializable)n -> {
            if (RichChar$.MODULE$.isLetter$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(n))))) {
                return n;
            }
            return new StringBuilder(1).append("x").append((String)n).toString();
        })), (Function1 & Serializable)x$1 -> new StringBuilder(11).append((String)x$1).append('_').append(MODULE$.randomString()).toString());
    }

    public String randomString() {
        return Random$.MODULE$.alphanumeric().take(12).mkString();
    }

    public String cygwinPath(@NotNull Path path) {
        if (path.isAbsolute()) {
            Predef$.MODULE$.assert(SystemUtils.IS_OS_WINDOWS);
            String root = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(((Object)path.getRoot()).toString()), ":\\");
            IndexedSeq parts = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), path.getNameCount()).map((Function1 & Serializable)i -> path.getName(BoxesRunTime.unboxToInt((Object)i)));
            return new StringBuilder(11).append("/cygdrive/").append(root).append("/").append(parts.mkString("/")).toString();
        }
        Predef$.MODULE$.assert(SystemUtils.IS_OS_WINDOWS);
        IndexedSeq parts = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), path.getNameCount()).map((Function1 & Serializable)i -> path.getName(BoxesRunTime.unboxToInt((Object)i)));
        return parts.mkString("/");
    }

    public static final /* synthetic */ char $anonfun$freshName$1(char c) {
        if (c < '\u0080' && RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(c))) {
            return c;
        }
        return '_';
    }

    private Utils$() {
    }
}

