/*
 * Decompiled with CFR 0.152.
 */
package de.unruh.isabelle.control;

import com.google.common.util.concurrent.Striped;
import de.unruh.isabelle.control.Isabelle;
import de.unruh.isabelle.control.IsabelleBuildException;
import de.unruh.isabelle.control.IsabelleJEditException;
import de.unruh.isabelle.misc.Utils$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxedUnit;
import scala.sys.process.Process$;
import scala.sys.process.ProcessBuilder;
import scala.sys.process.ProcessLogger$;

public final class Isabelle$ {
    public static final Isabelle$ MODULE$ = new Isabelle$();
    private static final Logger de$unruh$isabelle$control$Isabelle$$logger = LoggerFactory.getLogger((String)"de.unruh.isabelle.control.Isabelle");
    private static final Striped<ReadWriteLock> de$unruh$isabelle$control$Isabelle$$buildLocks = Striped.lazyWeakReadWriteLock((int)10);

    public void defaultCommandHandler(Isabelle.Data data) {
        throw new RuntimeException(new StringBuilder(73).append("Command ").append(data).append(" received from Isabelle, but default command handler is installed").toString());
    }

    public Logger de$unruh$isabelle$control$Isabelle$$logger() {
        return de$unruh$isabelle$control$Isabelle$$logger;
    }

    public Striped<ReadWriteLock> de$unruh$isabelle$control$Isabelle$$buildLocks() {
        return de$unruh$isabelle$control$Isabelle$$buildLocks;
    }

    public void buildSession(Isabelle.Setup setup) {
        Isabelle.Setup s = setup;
        ListBuffer isabelleArguments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        isabelleArguments.$plus$eq((Object)"build");
        isabelleArguments.$plus$eq((Object)"-b");
        Object object = setup.verbose() ? isabelleArguments.$plus$eq((Object)"-v") : BoxedUnit.UNIT;
        setup.sessionRoots().foreach((Function1 & Serializable)root -> (ListBuffer)isabelleArguments.$plus$eq((Object)"-d").$plus$eq((Object)MODULE$.de$unruh$isabelle$control$Isabelle$$cygwinAbs((Path)root, s)));
        isabelleArguments.$plus$eq((Object)setup.logic());
        scala.collection.immutable.Seq<String> cmd = this.de$unruh$isabelle$control$Isabelle$$makeIsabelleCommandLine(this.de$unruh$isabelle$control$Isabelle$$absPath(setup.isabelleHome(), s), (scala.collection.immutable.Seq<String>)isabelleArguments.toSeq());
        if (this.de$unruh$isabelle$control$Isabelle$$logger().isDebugEnabled()) {
            this.de$unruh$isabelle$control$Isabelle$$logger().debug(new StringBuilder(10).append("Cmd line: ").append(cmd.mkString(" ")).toString());
        }
        ProcessBuilder processBuilder = Process$.MODULE$.apply(cmd, Isabelle$.wd$2(setup).toAbsolutePath().toFile(), this.de$unruh$isabelle$control$Isabelle$$makeIsabelleEnvironment(s));
        ListBuffer errors = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        Lock lock = ((ReadWriteLock)this.de$unruh$isabelle$control$Isabelle$$buildLocks().get((Object)this.de$unruh$isabelle$control$Isabelle$$absPath(setup.isabelleHome(), s).normalize())).writeLock();
        lock.lockInterruptibly();
        try {
            if (0 != processBuilder.$bang(ProcessLogger$.MODULE$.apply((Function1 & Serializable)line -> {
                Isabelle$.$anonfun$buildSession$2(line);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)line -> {
                Isabelle$.$anonfun$buildSession$3(errors, line);
                return BoxedUnit.UNIT;
            }))) {
                throw new IsabelleBuildException(new StringBuilder(34).append("Isabelle build for session ").append(setup.logic()).append(" failed").toString(), (List<String>)errors.toList());
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void jedit(Isabelle.Setup setup, scala.collection.immutable.Seq<Path> files) {
        Isabelle.Setup s = setup;
        ListBuffer isabelleArguments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        isabelleArguments.$plus$eq((Object)"jedit");
        setup.sessionRoots().foreach((Function1 & Serializable)root -> (ListBuffer)isabelleArguments.$plus$eq((Object)"-d").$plus$eq((Object)MODULE$.de$unruh$isabelle$control$Isabelle$$cygwinAbs((Path)root, s)));
        isabelleArguments.$plus$eq((Object)"-l").$plus$eq((Object)setup.logic());
        isabelleArguments.$plus$eq((Object)"--");
        isabelleArguments.$plus$plus$eq((IterableOnce)files.map((Function1 & Serializable)path -> MODULE$.de$unruh$isabelle$control$Isabelle$$cygwinAbs((Path)path, s)));
        scala.collection.immutable.Seq<String> cmd = this.de$unruh$isabelle$control$Isabelle$$makeIsabelleCommandLine(this.de$unruh$isabelle$control$Isabelle$$absPath(setup.isabelleHome(), s), (scala.collection.immutable.Seq<String>)isabelleArguments.toSeq());
        if (this.de$unruh$isabelle$control$Isabelle$$logger().isDebugEnabled()) {
            this.de$unruh$isabelle$control$Isabelle$$logger().debug(new StringBuilder(10).append("Cmd line: ").append(cmd.mkString(" ")).toString());
        }
        ProcessBuilder processBuilder = Process$.MODULE$.apply((Seq)cmd.toSeq(), Isabelle$.wd$3(setup).toAbsolutePath().toFile(), this.de$unruh$isabelle$control$Isabelle$$makeIsabelleEnvironment(s));
        Lock lock = ((ReadWriteLock)this.de$unruh$isabelle$control$Isabelle$$buildLocks().get((Object)this.de$unruh$isabelle$control$Isabelle$$absPath(setup.isabelleHome(), s).normalize())).readLock();
        lock.lockInterruptibly();
        try {
            if (0 != processBuilder.$bang(ProcessLogger$.MODULE$.apply((Function1 & Serializable)line -> {
                Isabelle$.$anonfun$jedit$3(line);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)line -> {
                Isabelle$.$anonfun$jedit$4(line);
                return BoxedUnit.UNIT;
            }))) {
                throw new IsabelleJEditException("Could not start Isabelle/jEdit");
            }
        }
        finally {
            lock.unlock();
        }
    }

    public List<Tuple2<String, String>> de$unruh$isabelle$control$Isabelle$$makeIsabelleEnvironment(Isabelle.Setup setup) {
        ListBuffer env;
        block9: {
            BoxedUnit boxedUnit;
            block7: {
                block8: {
                    env = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
                    Option<Path> option = setup.userDir();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Path path = (Path)some.value();
                        env.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"USER_HOME"), (Object)this.de$unruh$isabelle$control$Isabelle$$cygwinAbs(path.getParent(), setup)));
                    } else if (None$.MODULE$.equals(option)) {
                    } else {
                        throw new MatchError(option);
                    }
                    if (!SystemUtils.IS_OS_WINDOWS) break block7;
                    env.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CHERE_INVOKING"), (Object)"true"));
                    env.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"HOME"), (Object)SystemUtils.getUserHome().getAbsolutePath()));
                    String string = System.getenv("TEMP");
                    switch (string == null ? 0 : string.hashCode()) {
                        case 0: {
                            if (string != null) break;
                            Path tempDir = Files.createTempDirectory("isabellecontrol", new FileAttribute[0]).toAbsolutePath();
                            tempDir.toFile().deleteOnExit();
                            env.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TEMP_WINDOWS"), (Object)((Object)tempDir).toString()));
                            break block8;
                        }
                    }
                    env.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TEMP_WINDOWS"), (Object)string));
                }
                boxedUnit = env.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"LANG"), (Object)"en_US.UTF-8"));
                break block9;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return env.toList();
    }

    public String de$unruh$isabelle$control$Isabelle$$cygwinIfWin(Path path) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return Utils$.MODULE$.cygwinPath(path);
        }
        return ((Object)path).toString();
    }

    public Path de$unruh$isabelle$control$Isabelle$$absPath(Path path, Isabelle.Setup setup) {
        return setup.workingDirectory().resolve(path).toAbsolutePath();
    }

    public String de$unruh$isabelle$control$Isabelle$$cygwinAbs(Path path, Isabelle.Setup setup) {
        return this.de$unruh$isabelle$control$Isabelle$$cygwinIfWin(this.de$unruh$isabelle$control$Isabelle$$absPath(path, setup));
    }

    public scala.collection.immutable.Seq<String> de$unruh$isabelle$control$Isabelle$$makeIsabelleCommandLine(Path isabelleHome, scala.collection.immutable.Seq<String> arguments) {
        if (SystemUtils.IS_OS_WINDOWS) {
            String bash = ((Object)isabelleHome.resolve("contrib").resolve("cygwin").resolve("bin").resolve("bash")).toString();
            String isabelle = Utils$.MODULE$.cygwinPath(isabelleHome.resolve("bin").resolve("isabelle"));
            return new .colon.colon((Object)bash, (List)new .colon.colon((Object)"--login", (List)new .colon.colon((Object)"-c", (List)new .colon.colon((Object)((List)new .colon.colon((Object)isabelle, (List)Nil$.MODULE$).$plus$plus(arguments)).map((Function1 & Serializable)x$1 -> StringEscapeUtils.escapeXSI((String)x$1)).mkString(" "), (List)Nil$.MODULE$))));
        }
        return (scala.collection.immutable.Seq)new .colon.colon((Object)((Object)isabelleHome.resolve("bin").resolve("isabelle")).toString(), (List)Nil$.MODULE$).$plus$plus(arguments);
    }

    private static final Path wd$2(Isabelle.Setup setup$2) {
        return setup$2.workingDirectory();
    }

    public static final /* synthetic */ void $anonfun$buildSession$2(String line) {
        if (MODULE$.de$unruh$isabelle$control$Isabelle$$logger().isDebugEnabled()) {
            MODULE$.de$unruh$isabelle$control$Isabelle$$logger().debug(new StringBuilder(16).append("Isabelle build: ").append(line).toString());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$buildSession$3(ListBuffer errors$1, String line) {
        errors$1.append((Object)line);
        if (MODULE$.de$unruh$isabelle$control$Isabelle$$logger().isWarnEnabled()) {
            MODULE$.de$unruh$isabelle$control$Isabelle$$logger().warn(new StringBuilder(16).append("Isabelle build: ").append(line).toString());
            return;
        }
    }

    private static final Path wd$3(Isabelle.Setup setup$3) {
        return setup$3.workingDirectory();
    }

    public static final /* synthetic */ void $anonfun$jedit$3(String line) {
        if (MODULE$.de$unruh$isabelle$control$Isabelle$$logger().isDebugEnabled()) {
            MODULE$.de$unruh$isabelle$control$Isabelle$$logger().debug(new StringBuilder(16).append("Isabelle jedit: ").append(line).toString());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$jedit$4(String line) {
        if (MODULE$.de$unruh$isabelle$control$Isabelle$$logger().isWarnEnabled()) {
            MODULE$.de$unruh$isabelle$control$Isabelle$$logger().warn(new StringBuilder(16).append("Isabelle jedit: ").append(line).toString());
            return;
        }
    }

    private Isabelle$() {
    }
}

