/*
 * Decompiled with CFR 0.152.
 */
package de.unruh.isabelle.misc;

import java.io.Serializable;
import java.nio.file.Path;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;
import scalaz.syntax.IdOps$;
import scalaz.syntax.package$;

public final class Utils$ {
    public static Utils$ MODULE$;
    private final Logger logger;

    static {
        new Utils$();
    }

    private Logger logger() {
        return this.logger;
    }

    public boolean checkEnvironmentFlag(String variable) {
        String content;
        String string;
        try {
            string = System.getenv(variable);
        }
        catch (SecurityException e) {
            if (this.logger().isDebugEnabled()) {
                this.logger().debug(new StringBuilder(33).append("Cannot read environment variable ").append(variable).toString(), (Throwable)e);
            }
            string = content = null;
        }
        if (content == null) {
            return false;
        }
        String string2 = content.toLowerCase();
        return "1".equals(string2) ? true : "true".equals(string2);
    }

    public void destroyProcessThoroughly(Process process) {
        ProcessHandle processHandle = process.toHandle();
        List processes = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(process.descendants().iterator()).asScala()).toList().$colon$colon((Object)processHandle);
        processes.foreach((Function1 & Serializable & scala.Serializable)p -> {
            Boolean bl;
            try {
                bl = BoxesRunTime.boxToBoolean((boolean)p.destroy());
            }
            catch (Exception e) {
                e.printStackTrace();
                bl = BoxedUnit.UNIT;
            }
            return bl;
        });
        Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Thread.sleep(1000L);
            processes.foreach((Function1 & Serializable & scala.Serializable)p -> {
                Boolean bl;
                try {
                    bl = BoxesRunTime.boxToBoolean((boolean)p.destroyForcibly());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    bl = BoxedUnit.UNIT;
                }
                return bl;
            });
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    public String freshName(String name) {
        return (String)IdOps$.MODULE$.into$extension(package$.MODULE$.id().ToIdOps(IdOps$.MODULE$.into$extension(package$.MODULE$.id().ToIdOps(new StringOps(Predef$.MODULE$.augmentString(name)).map((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToCharacter((char)Utils$.$anonfun$freshName$1(BoxesRunTime.unboxToChar((Object)c))), Predef$.MODULE$.StringCanBuildFrom())), (Function1 & Serializable & scala.Serializable)n -> {
            if (RichChar$.MODULE$.isLetter$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(n)).head())))) {
                return n;
            }
            return new StringBuilder(1).append("x").append((String)n).toString();
        })), (Function1 & Serializable & scala.Serializable)x$2 -> new StringBuilder(0).append((String)x$2).append('_').append(MODULE$.randomString()).toString());
    }

    public String randomString() {
        return Random$.MODULE$.alphanumeric().take(12).mkString();
    }

    public String cygwinPath(Path path) {
        if (path.isAbsolute()) {
            Predef$.MODULE$.assert(SystemUtils.IS_OS_WINDOWS);
            String root = new StringOps(Predef$.MODULE$.augmentString(((Object)path.getRoot()).toString())).stripSuffix(":\\");
            IndexedSeq parts = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), path.getNameCount()).map((Function1 & Serializable & scala.Serializable)i -> path.getName(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            return new StringBuilder(11).append("/cygdrive/").append(root).append("/").append(parts.mkString("/")).toString();
        }
        Predef$.MODULE$.assert(SystemUtils.IS_OS_WINDOWS);
        IndexedSeq parts = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), path.getNameCount()).map((Function1 & Serializable & scala.Serializable)i -> path.getName(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        return parts.mkString("/");
    }

    public static final /* synthetic */ char $anonfun$freshName$1(char c) {
        if (c < '\u0080' && RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(c))) {
            return c;
        }
        return '_';
    }

    private Utils$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"de.unruh.isabelle.misc.Utils");
    }
}

