/*
 * Decompiled with CFR 0.152.
 */
package de.unruh.isabelle.control;

import com.google.common.util.concurrent.Striped;
import de.unruh.isabelle.control.Isabelle;
import de.unruh.isabelle.control.IsabelleBuildException;
import de.unruh.isabelle.control.IsabelleJEditException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.log4s.LogLevel;
import org.log4s.Logger;
import org.log4s.Logger$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxedUnit;
import scala.sys.process.Process$;
import scala.sys.process.ProcessBuilder;
import scala.sys.process.ProcessLogger$;

public final class Isabelle$ {
    public static Isabelle$ MODULE$;
    private final Logger de$unruh$isabelle$control$Isabelle$$logger;
    private final Striped<ReadWriteLock> de$unruh$isabelle$control$Isabelle$$buildLocks;

    static {
        new Isabelle$();
    }

    public boolean $lessinit$greater$default$2() {
        return true;
    }

    public Logger de$unruh$isabelle$control$Isabelle$$logger() {
        return this.de$unruh$isabelle$control$Isabelle$$logger;
    }

    public void de$unruh$isabelle$control$Isabelle$$logStream(InputStream stream, LogLevel level) {
        Logger.LevelLogger log = Logger$.MODULE$.apply$extension5(this.de$unruh$isabelle$control$Isabelle$$logger(), level);
        Thread thread = new Thread(level, stream){
            private final InputStream stream$4;

            public void run() {
                new BufferedReader(new InputStreamReader(this.stream$4)).lines().forEach(line -> {
                    block0: {
                        if (!Isabelle$.MODULE$.de$unruh$isabelle$control$Isabelle$$logger().isDebugEnabled()) break block0;
                        Isabelle$.MODULE$.de$unruh$isabelle$control$Isabelle$$logger().debug(line);
                    }
                });
            }
            {
                this.stream$4 = stream$4;
                super(new StringBuilder(24).append("Isabelle output logger, ").append(level$1).toString());
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public Striped<ReadWriteLock> de$unruh$isabelle$control$Isabelle$$buildLocks() {
        return this.de$unruh$isabelle$control$Isabelle$$buildLocks;
    }

    public void buildSession(Isabelle.Setup setup) {
        Path isabelleBinary = setup.isabelleHome().resolve("bin").resolve("isabelle");
        ListBuffer cmd = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        cmd.$plus$eq((Object)Isabelle$.str$2(isabelleBinary, setup)).$plus$eq((Object)"build");
        cmd.$plus$eq((Object)"-b");
        setup.sessionRoots().foreach((Function1 & Serializable & scala.Serializable)root -> cmd.$plus$eq((Object)"-d").$plus$eq((Object)Isabelle$.str$2(root, setup)));
        cmd.$plus$eq((Object)setup.logic());
        if (this.de$unruh$isabelle$control$Isabelle$$logger().isDebugEnabled()) {
            this.de$unruh$isabelle$control$Isabelle$$logger().debug(new StringBuilder(10).append("Cmd line: ").append(cmd.mkString(" ")).toString());
        }
        List extraEnv = (List)setup.userDir().toList().map((Function1 & Serializable & scala.Serializable)userDir -> new Tuple2((Object)"USER_HOME", (Object)Isabelle$.str$2(userDir.getParent(), setup)), List$.MODULE$.canBuildFrom());
        ProcessBuilder processBuilder = Process$.MODULE$.apply(cmd.toSeq(), Isabelle$.wd$2(setup).toAbsolutePath().toFile(), (Seq)extraEnv);
        ListBuffer errors = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Lock lock = ((ReadWriteLock)this.de$unruh$isabelle$control$Isabelle$$buildLocks().get((Object)Isabelle$.wd$2(setup).resolve(setup.isabelleHome()).toAbsolutePath().normalize())).writeLock();
        lock.lockInterruptibly();
        try {
            if (0 != processBuilder.$bang(ProcessLogger$.MODULE$.apply((Function1 & Serializable & scala.Serializable)line -> {
                Isabelle$.$anonfun$buildSession$3(line);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable & scala.Serializable)line -> {
                Isabelle$.$anonfun$buildSession$4(errors, line);
                return BoxedUnit.UNIT;
            }))) {
                throw new IsabelleBuildException(new StringBuilder(34).append("Isabelle build for session ").append(setup.logic()).append(" failed").toString(), (List<String>)errors.toList());
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void jedit(Isabelle.Setup setup, Seq<Path> files) {
        Path isabelleBinary = setup.isabelleHome().resolve("bin").resolve("isabelle");
        ListBuffer cmd = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        cmd.$plus$eq((Object)Isabelle$.str$3(isabelleBinary, setup)).$plus$eq((Object)"jedit");
        setup.sessionRoots().foreach((Function1 & Serializable & scala.Serializable)root -> cmd.$plus$eq((Object)"-d").$plus$eq((Object)Isabelle$.str$3(root, setup)));
        cmd.$plus$eq((Object)"-l").$plus$eq((Object)setup.logic());
        cmd.$plus$eq((Object)"--");
        cmd.$plus$plus$eq((TraversableOnce)files.map((Function1 & Serializable & scala.Serializable)x$6 -> ((Object)x$6.toAbsolutePath()).toString(), Seq$.MODULE$.canBuildFrom()));
        if (this.de$unruh$isabelle$control$Isabelle$$logger().isDebugEnabled()) {
            this.de$unruh$isabelle$control$Isabelle$$logger().debug(new StringBuilder(10).append("Cmd line: ").append(cmd.mkString(" ")).toString());
        }
        List extraEnv = (List)setup.userDir().toList().map((Function1 & Serializable & scala.Serializable)userDir -> new Tuple2((Object)"USER_HOME", (Object)Isabelle$.str$3(userDir.getParent(), setup)), List$.MODULE$.canBuildFrom());
        ProcessBuilder processBuilder = Process$.MODULE$.apply(cmd.toSeq(), Isabelle$.wd$3(setup).toAbsolutePath().toFile(), (Seq)extraEnv);
        Lock lock = ((ReadWriteLock)this.de$unruh$isabelle$control$Isabelle$$buildLocks().get((Object)Isabelle$.wd$3(setup).resolve(setup.isabelleHome()).toAbsolutePath().normalize())).readLock();
        lock.lockInterruptibly();
        try {
            if (0 != processBuilder.$bang(ProcessLogger$.MODULE$.apply((Function1 & Serializable & scala.Serializable)line -> {
                Isabelle$.$anonfun$jedit$4(line);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable & scala.Serializable)line -> {
                Isabelle$.$anonfun$jedit$5(line);
                return BoxedUnit.UNIT;
            }))) {
                throw new IsabelleJEditException("Could not start Isabelle/jEdit");
            }
        }
        finally {
            lock.unlock();
        }
    }

    private static final Path wd$2(Isabelle.Setup setup$1) {
        return setup$1.workingDirectory();
    }

    private static final String str$2(Path path, Isabelle.Setup setup$1) {
        return ((Object)Isabelle$.wd$2(setup$1).resolve(path).toAbsolutePath()).toString();
    }

    public static final /* synthetic */ void $anonfun$buildSession$3(String line) {
        block0: {
            if (!MODULE$.de$unruh$isabelle$control$Isabelle$$logger().isDebugEnabled()) break block0;
            MODULE$.de$unruh$isabelle$control$Isabelle$$logger().debug(new StringBuilder(16).append("Isabelle build: ").append(line).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$buildSession$4(ListBuffer errors$1, String line) {
        block0: {
            errors$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{line}));
            if (!MODULE$.de$unruh$isabelle$control$Isabelle$$logger().isWarnEnabled()) break block0;
            MODULE$.de$unruh$isabelle$control$Isabelle$$logger().warn(new StringBuilder(16).append("Isabelle build: ").append(line).toString());
        }
    }

    private static final Path wd$3(Isabelle.Setup setup$2) {
        return setup$2.workingDirectory();
    }

    private static final String str$3(Path path, Isabelle.Setup setup$2) {
        return ((Object)Isabelle$.wd$3(setup$2).resolve(path).toAbsolutePath()).toString();
    }

    public static final /* synthetic */ void $anonfun$jedit$4(String line) {
        block0: {
            if (!MODULE$.de$unruh$isabelle$control$Isabelle$$logger().isDebugEnabled()) break block0;
            MODULE$.de$unruh$isabelle$control$Isabelle$$logger().debug(new StringBuilder(16).append("Isabelle jedit: ").append(line).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$jedit$5(String line) {
        block0: {
            if (!MODULE$.de$unruh$isabelle$control$Isabelle$$logger().isWarnEnabled()) break block0;
            MODULE$.de$unruh$isabelle$control$Isabelle$$logger().warn(new StringBuilder(16).append("Isabelle jedit: ").append(line).toString());
        }
    }

    private Isabelle$() {
        MODULE$ = this;
        this.de$unruh$isabelle$control$Isabelle$$logger = LoggerFactory.getLogger((String)"de.unruh.isabelle.control.Isabelle");
        this.de$unruh$isabelle$control$Isabelle$$buildLocks = Striped.lazyWeakReadWriteLock((int)10);
    }
}

