/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.pack;

import de.unkrig.commons.file.ExceptionHandler;
import de.unkrig.commons.file.fileprocessing.FileProcessor;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormatFactory;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.zip.ZipArchiveFormat;
import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormatFactory;
import de.unkrig.commons.text.LevelFilteredPrinter;
import de.unkrig.commons.text.Printers;
import de.unkrig.commons.text.pattern.Glob;
import de.unkrig.commons.util.CommandLineOptions;
import de.unkrig.commons.util.annotation.CommandLineOption;
import de.unkrig.commons.util.annotation.RegexFlags;
import de.unkrig.commons.util.logging.SimpleLogging;
import de.unkrig.zz.pack.Pack;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.compressors.CompressorException;

public final class Main {
    private final Pack pack = new Pack();
    private final LevelFilteredPrinter levelFilteredPrinter;

    private Main() {
        this.pack.setArchiveFormat(ZipArchiveFormat.get());
        this.pack.setExceptionHandler(new ExceptionHandler<IOException>(){

            @Override
            public void handle(String path, IOException ioe) {
                Printers.error(path, ioe);
            }

            @Override
            public void handle(String path, RuntimeException re) {
                Printers.error(path, re);
            }
        });
        this.levelFilteredPrinter = new LevelFilteredPrinter();
    }

    public static void main(final String[] args) {
        new Main().levelFilteredPrinter.run(new Runnable(){

            @Override
            public void run() {
                new Main(null).main2(args);
            }
        });
    }

    private void main2(String[] args) {
        try {
            this.main3(args);
        }
        catch (Exception e) {
            Printers.error(null, e);
        }
    }

    private void main3(String[] args) throws Exception {
        if ((args = CommandLineOptions.parse(args, this)).length == 0) {
            System.err.println("Archive file missing, try \"--help\".");
            System.exit(1);
        }
        File archiveFile = new File(args[0]);
        if (args.length == 1) {
            System.err.println("Input files missing, try \"--help\".");
            System.exit(1);
        }
        FileProcessor<Void> fp = this.pack.fileProcessor(true);
        FileOutputStream os = new FileOutputStream(archiveFile);
        Closeable c = os;
        try {
            c = this.pack.setOutputStream(os);
            int i = 1;
            while (i < args.length) {
                File file = new File(args[i]);
                fp.process(file.getPath(), file);
                ++i;
            }
            c.close();
        }
        finally {
            try {
                c.close();
            }
            catch (Exception exception) {}
        }
    }

    @CommandLineOption
    public static void help() throws IOException {
        System.setProperty("archive.formats", ArchiveFormatFactory.allFormats().toString());
        System.setProperty("compression.formats", CompressionFormatFactory.allFormats().toString());
        CommandLineOptions.printResource(Main.class, "main(String[]).txt", Charset.forName("UTF-8"), (OutputStream)System.out);
        System.exit(0);
    }

    @CommandLineOption
    public void setArchiveFormat(String format) throws ArchiveException {
        this.pack.setArchiveFormat(ArchiveFormatFactory.forFormatName(format));
    }

    @CommandLineOption
    public void setCompressionFormat(String format) throws CompressorException {
        this.pack.setCompressionFormat(CompressionFormatFactory.forFormatName(format));
    }

    @CommandLineOption
    public void dontSortDirectoryMembers() {
        this.pack.setDirectoryMemberNameComparator(null);
    }

    @CommandLineOption
    public void lookInto(@RegexFlags(value=-1610612736) Glob discriminator) {
        this.pack.setLookIntoFormat(discriminator);
    }

    @CommandLineOption
    public void nowarn() {
        this.levelFilteredPrinter.setNoWarn();
    }

    @CommandLineOption(name={"q", "quiet"})
    public void quiet() {
        this.levelFilteredPrinter.setQuiet();
    }

    @CommandLineOption
    public void verbose() {
        this.levelFilteredPrinter.setVerbose();
    }

    @CommandLineOption
    public void debug() {
        this.levelFilteredPrinter.setDebug();
    }

    @CommandLineOption(cardinality=CommandLineOption.Cardinality.ANY)
    public static void addLog(String spec) {
        SimpleLogging.configureLoggers(spec);
    }

    @Deprecated
    @CommandLineOption(name={"zip", "zz", "nested-zip", "gzip"})
    public static void noLongerSupported() {
        System.err.println("Command line option is no longer supported - try \"--help\".");
        System.exit(1);
    }

    /* synthetic */ Main(Main main) {
        this();
    }
}

