/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.concurrent;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.Consumer;
import de.unkrig.commons.nullanalysis.NotNull;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class ConcurrentUtil {
    public static final ExecutorService SEQUENTIAL_EXECUTOR_SERVICE;

    static {
        AssertionUtil.enableAssertionsForThisClass();
        SEQUENTIAL_EXECUTOR_SERVICE = new AbstractExecutorService(){

            @Override
            @NotNullByDefault(value=false)
            public void execute(Runnable command) {
                command.run();
            }

            @Override
            public List<Runnable> shutdownNow() {
                throw new UnsupportedOperationException("shutdownNow");
            }

            @Override
            public void shutdown() {
                throw new UnsupportedOperationException("shutdown");
            }

            @Override
            public boolean isTerminated() {
                return false;
            }

            @Override
            public boolean isShutdown() {
                return false;
            }

            @Override
            @NotNullByDefault(value=false)
            public boolean awaitTermination(long timeout, TimeUnit unit) {
                return true;
            }
        };
    }

    private ConcurrentUtil() {
    }

    public static Runnable count(int n, final Runnable delegate) {
        return new Runnable(n){
            AtomicInteger ai;
            {
                this.ai = new AtomicInteger(n);
            }

            @Override
            public void run() {
                int i = this.ai.decrementAndGet();
                if (i < 0) {
                    throw new IllegalStateException();
                }
                if (i == 0) {
                    delegate.run();
                }
            }
        };
    }

    public static <T> Consumer<T> aggregate(final int n, final Consumer<? super List<T>> delegate) {
        return new Consumer<T>(){
            final List<T> collectedSubjects = new ArrayList();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void consume(@NotNull T subject) {
                int size;
                List list = this.collectedSubjects;
                synchronized (list) {
                    size = this.collectedSubjects.size();
                    if (size >= n) {
                        throw new IllegalStateException();
                    }
                    this.collectedSubjects.add(subject);
                }
                if (++size == n) {
                    delegate.consume(Collections.unmodifiableList(this.collectedSubjects));
                }
            }
        };
    }

    public static <T> List<Consumer<T>> collect(int n, final Consumer<? super List<T>> delegate) {
        final ArrayList collectedSubjects = new ArrayList(n);
        final AtomicBoolean[] invoked = new AtomicBoolean[n];
        int i = 0;
        while (i < n) {
            invoked[i] = new AtomicBoolean(false);
            ++i;
        }
        final AtomicInteger remaining = new AtomicInteger(n);
        ArrayList<Consumer<T>> result = new ArrayList<Consumer<T>>(n);
        int i2 = 0;
        while (i2 < n) {
            final int idx = i2;
            result.set(i2, new Consumer<T>(){

                @Override
                public void consume(@NotNull T subject) {
                    if (!invoked[idx].compareAndSet(false, true)) {
                        throw new IllegalStateException();
                    }
                    collectedSubjects.set(idx, subject);
                    int r = remaining.decrementAndGet();
                    if (!$assertionsDisabled && r < 0) {
                        throw new AssertionError();
                    }
                    if (r == 0) {
                        delegate.consume(collectedSubjects);
                    }
                }
            });
            ++i2;
        }
        return result;
    }
}

