/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.collections;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.ObjectUtil;
import de.unkrig.commons.lang.StringUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.collections.Peekerator;
import de.unkrig.commons.util.collections.Peekerators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringPeekerator
implements Peekerator<String> {
    private final Peekerator<String> delegate;

    static {
        AssertionUtil.enableAssertionsForThisClass();
    }

    public StringPeekerator(Peekerator<String> delegate) {
        this.delegate = delegate;
    }

    public StringPeekerator(Iterator<String> delegate) {
        this.delegate = Peekerators.from(delegate);
    }

    public StringPeekerator(ListIterator<String> delegate) {
        this.delegate = Peekerators.from(delegate);
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }

    @Override
    public String peek() {
        return this.delegate.peek();
    }

    public boolean peek(@Nullable String expected) {
        return ObjectUtil.equals(expected, this.delegate.peek());
    }

    public boolean peekIgnoreCase(String expected) {
        return StringUtil.equalsIgnoreCase(expected, this.delegate.peek());
    }

    @Nullable
    public Matcher peek(Pattern pattern) {
        String actual = this.delegate.peek();
        if (actual == null) {
            return null;
        }
        Matcher m = pattern.matcher(actual);
        return m.matches() ? m : null;
    }

    @Override
    @Nullable
    public String next() {
        return this.delegate.next();
    }

    public boolean nextIfEquals(@Nullable String expected) {
        boolean result = ObjectUtil.equals(this.delegate.peek(), expected);
        if (result) {
            this.delegate.next();
        }
        return result;
    }

    public boolean nextIfEqualsIgnoreCase(@Nullable String expected) {
        boolean result = StringUtil.equalsIgnoreCase(this.delegate.peek(), expected);
        if (result) {
            this.delegate.next();
        }
        return result;
    }

    public int nextIfEquals(String ... expected) {
        String actual = this.delegate.peek();
        int i = 0;
        while (i < expected.length) {
            if (ObjectUtil.equals(expected[i], actual)) {
                this.delegate.next();
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int nextIfEqualsIgnoreCase(String ... expected) {
        String actual = this.delegate.peek();
        int i = 0;
        while (i < expected.length) {
            if (StringUtil.equalsIgnoreCase(expected[i], actual)) {
                this.delegate.next();
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Nullable
    public Matcher nextIfMatches(Pattern pattern) {
        String actual = this.delegate.peek();
        if (actual == null) {
            return null;
        }
        Matcher m = pattern.matcher(actual);
        if (!m.matches()) {
            return null;
        }
        this.delegate.next();
        return m;
    }

    public void nextEquals(String expected) {
        String actual = this.delegate.next();
        if (!ObjectUtil.equals(actual, expected)) {
            throw new NoSuchElementException("Expected '" + expected + "' instead of '" + actual + "'");
        }
    }

    public void nextEqualsIgnoreCase(String expected) {
        String actual = this.delegate.next();
        if (!StringUtil.equalsIgnoreCase(actual, expected)) {
            throw new NoSuchElementException("Expected '" + expected + "' instead of '" + actual + "'");
        }
    }

    public int nextEquals(String ... expected) {
        String actual = this.delegate.next();
        int i = 0;
        while (i < expected.length) {
            if (ObjectUtil.equals(actual, expected[i])) {
                return i;
            }
            ++i;
        }
        throw new NoSuchElementException("Expected one of " + Arrays.toString(expected) + " instead of \"" + actual + "\"");
    }

    public int nextEqualsIgnoreCase(String ... expected) {
        String actual = this.delegate.next();
        int i = 0;
        while (i < expected.length) {
            if (StringUtil.equalsIgnoreCase(actual, expected[i])) {
                return i;
            }
            ++i;
        }
        throw new NoSuchElementException("Expected one of " + Arrays.toString(expected) + " instead of \"" + actual + "\"");
    }

    public void nextMatches(Pattern pattern) {
        String actual = this.delegate.next();
        if (actual == null) {
            throw new NoSuchElementException("null");
        }
        if (!pattern.matcher(actual).matches()) {
            throw new NoSuchElementException("Expected '" + pattern + "' instead of '" + actual + "'");
        }
    }

    public String[] rest() {
        ArrayList<String> result = new ArrayList<String>();
        while (this.delegate.hasNext()) {
            result.add(this.delegate.next());
        }
        return result.toArray(new String[result.size()]);
    }
}

