/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util;

import java.lang.reflect.Array;

public final class ArrayUtil {
    private ArrayUtil() {
    }

    public static <T> T[] append(T[] a, T ... values) {
        Object[] result = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length + values.length);
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(values, 0, result, a.length, values.length);
        return result;
    }

    public static char[] append(char[] a, char ... values) {
        char[] result = new char[a.length + values.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(values, 0, result, a.length, values.length);
        return result;
    }

    public static char[][] mirror(char[] ... cas) {
        int n1 = cas.length;
        if (n1 == 0) {
            return cas;
        }
        int n2 = cas[0].length;
        char[][] result = new char[n2][n1];
        int j = 0;
        while (j < n2) {
            result[j][0] = cas[0][j];
            ++j;
        }
        int i = 1;
        while (i < n1) {
            if (cas[i].length != n2) {
                throw new IllegalArgumentException("Length of element #" + i + " should be " + n2 + ", but is " + cas[i].length);
            }
            int j2 = 0;
            while (j2 < n2) {
                result[j2][i] = cas[i][j2];
                ++j2;
            }
            ++i;
        }
        return result;
    }
}

