/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.scanner;

import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.scanner.AbstractScanner;
import de.unkrig.commons.text.scanner.ScanException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StatefulScanner<TT extends Enum<TT>, S extends Enum<S>>
extends AbstractScanner<TT> {
    @Nullable
    public final EnumSet<S> ANY_STATE = null;
    @Nullable
    public final S REMAIN = null;
    private final List<List<Rule>> stateStack = new ArrayList<List<Rule>>();
    private final List<Rule> defaultStateRules;
    private final Map<S, List<Rule>> nonDefaultStateRules;
    private List<Rule> currentStateRules;

    public StatefulScanner(Class<S> states) {
        this.defaultStateRules = new ArrayList<Rule>();
        this.nonDefaultStateRules = new HashMap<S, List<Rule>>();
        this.currentStateRules = this.defaultStateRules;
        for (Enum state : (Enum[])states.getEnumConstants()) {
            this.nonDefaultStateRules.put(state, new ArrayList());
        }
    }

    public StatefulScanner(StatefulScanner<TT, S> that) {
        this.defaultStateRules = that.defaultStateRules;
        this.nonDefaultStateRules = that.nonDefaultStateRules;
        this.currentStateRules = this.defaultStateRules;
    }

    public Rule addRule(String regex, TT tokenType) {
        Rule rule = new Rule(this, regex, tokenType, this.defaultStateRules);
        this.defaultStateRules.add(rule);
        return rule;
    }

    public Rule addRule(S state, String regex, TT tokenType) {
        Rule rule = new Rule(this, regex, tokenType, this.defaultStateRules);
        this.nonDefaultStateRules.get(state).add(rule);
        return rule;
    }

    public Rule addRule(@Nullable EnumSet<S> states, String regex, TT tokenType) {
        Rule rule = new Rule(this, regex, tokenType, this.defaultStateRules);
        if (states == null) {
            for (List<Rule> rules : this.nonDefaultStateRules.values()) {
                rules.add(rule);
            }
            this.defaultStateRules.add(rule);
        } else {
            for (Enum s : states) {
                this.nonDefaultStateRules.get(s).add(rule);
            }
        }
        return rule;
    }

    @Nullable
    public S getCurrentState() {
        if (this.currentStateRules == this.defaultStateRules) {
            return null;
        }
        for (Map.Entry<S, List<Rule>> e : this.nonDefaultStateRules.entrySet()) {
            Enum state = (Enum)e.getKey();
            List<Rule> rules = e.getValue();
            if (rules != this.currentStateRules) continue;
            return (S)state;
        }
        throw new AssertionError(this.currentStateRules);
    }

    public void setCurrentState(@Nullable S newState) {
        this.currentStateRules = newState == null ? this.defaultStateRules : this.nonDefaultStateRules.get(newState);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public AbstractScanner.Token<TT> produce() throws ScanException {
        int length = this.cs.length();
        if (this.offset == length) {
            return null;
        }
        for (Rule rule : this.currentStateRules) {
            Matcher matcher = rule.regex.matcher(this.cs);
            matcher.region(this.offset, length);
            if (!matcher.lookingAt()) continue;
            if (rule.popState) {
                this.currentStateRules = this.stateStack.remove(this.stateStack.size() - 1);
            } else {
                if (rule.pushState) {
                    this.stateStack.add(this.currentStateRules);
                }
                if (rule.nextStateRules != null) {
                    this.currentStateRules = rule.nextStateRules;
                }
            }
            this.previousTokenOffset = this.offset;
            this.offset = matcher.end();
            int gc = matcher.groupCount();
            String[] captured = new String[gc];
            for (int i = 0; i < gc; ++i) {
                captured[i] = matcher.group(i + 1);
            }
            return new AbstractScanner.Token(rule.tokenType, matcher.group(), captured);
        }
        String message = "Unexpected character \"" + this.cs.charAt(this.offset) + "\" at offset " + this.offset + " of input string \"" + this.cs + "\"";
        if (this.currentStateRules == this.defaultStateRules) {
            message = message + " in default state";
        } else {
            for (Map.Entry<S, List<Rule>> entry : this.nonDefaultStateRules.entrySet()) {
                Enum state = (Enum)entry.getKey();
                List<Rule> rules = entry.getValue();
                if (this.currentStateRules != rules) continue;
                message = message + " in state " + state;
                break;
            }
        }
        if (this.currentStateRules.size() == 1) {
            message = message + "; expected " + this.currentStateRules.get((int)0).tokenType;
        } else if (this.currentStateRules.size() > 1) {
            void var3_7;
            message = message + "; expected one of " + this.currentStateRules.get((int)0).tokenType;
            boolean bl = true;
            while (var3_7 < this.currentStateRules.size()) {
                message = message + ", " + this.currentStateRules.get((int)var3_7).tokenType;
                ++var3_7;
            }
        }
        throw new ScanException(message);
    }

    @Deprecated
    public Rule addRule(String regex, TT tokenType, S nextState) {
        return this.addRule(regex, tokenType).goTo(nextState);
    }

    @Deprecated
    public Rule addRule(S state, String regex, TT tokenType, @Nullable S nextState) {
        return this.addRule(state, regex, tokenType).goTo(nextState);
    }

    @Deprecated
    public Rule addRule(@Nullable EnumSet<S> states, String regex, TT tokenType, @Nullable S nextState) {
        return this.addRule(states, regex, tokenType).goTo(nextState);
    }

    public static class Rule {
        final TT tokenType;
        final Pattern regex;
        @Nullable
        List<Rule> nextStateRules;
        private boolean pushState;
        private boolean popState;
        final /* synthetic */ StatefulScanner this$0;

        Rule(String regex, @Nullable TT tokenType, List<Rule> nextStateRules) {
            this.this$0 = this$0;
            this.regex = Pattern.compile(regex);
            this.tokenType = tokenType;
            this.nextStateRules = nextStateRules;
        }

        public Rule goTo(@Nullable S nextState) {
            this.nextStateRules = (List)this.this$0.nonDefaultStateRules.get(nextState);
            return this;
        }

        public Rule push(S nextState) {
            this.pushState = true;
            this.nextStateRules = (List)this.this$0.nonDefaultStateRules.get(nextState);
            return this;
        }

        public Rule pop() {
            this.popState = true;
            return this;
        }

        public String toString() {
            return ">>" + this.regex + "<< => " + this.tokenType;
        }
    }
}

