/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang.protocol;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.Transformer;
import de.unkrig.commons.lang.protocol.TransformerWhichThrows;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class TransformerUtil {
    private static final Transformer IDENTITY;

    static {
        AssertionUtil.enableAssertionsForThisClass();
        IDENTITY = new Transformer(){

            @Override
            public Object transform(Object in) {
                return in;
            }
        };
    }

    private TransformerUtil() {
    }

    public static <O, I extends O, EX extends Throwable> TransformerWhichThrows<I, O, EX> identity() {
        return IDENTITY;
    }

    public static <T, EX extends Throwable> TransformerWhichThrows<? super T, ? extends T, ? extends EX> chain(final TransformerWhichThrows<? super T, ? extends T, ? extends EX> ... transformers) {
        if (transformers.length == 0) {
            return TransformerUtil.identity();
        }
        if (transformers.length == 1) {
            return transformers[0];
        }
        return new TransformerWhichThrows<T, T, EX>(){

            @Override
            public T transform(T in) throws Throwable {
                TransformerWhichThrows[] transformerWhichThrowsArray = transformers;
                int n = transformers.length;
                int n2 = 0;
                while (n2 < n) {
                    TransformerWhichThrows transformer = transformerWhichThrowsArray[n2];
                    in = transformer.transform(in);
                    ++n2;
                }
                return in;
            }
        };
    }

    public static <I, O, EX extends Throwable> TransformerWhichThrows<I, O, EX> asTransformerWhichThrows(TransformerWhichThrows<? super I, ? extends O, ? extends RuntimeException> source) {
        TransformerWhichThrows<? super I, ? extends O, ? extends RuntimeException> result = source;
        return result;
    }

    public static <I, O, EX extends RuntimeException> Transformer<I, O> asTransformer(final TransformerWhichThrows<? super I, ? extends O, EX> source) {
        return new Transformer<I, O>(){

            @Override
            public O transform(I in) {
                return source.transform(in);
            }
        };
    }

    public static <I, O, EX extends Throwable> TransformerWhichThrows<I, O, EX> combine(final I extraInput, final O extraOutput, final TransformerWhichThrows<? super I, ? extends O, EX> delegate) {
        return new TransformerWhichThrows<I, O, EX>(){

            @Override
            public O transform(I in) throws Throwable {
                if (in.equals(extraInput)) {
                    return extraOutput;
                }
                return delegate.transform(in);
            }
        };
    }

    public static <I, O, EX extends Throwable> TransformerWhichThrows<I, O, EX> addMappings(final TransformerWhichThrows<? super I, ? extends O, ? extends EX> delegate, Object ... keysAndValues) {
        final HashMap<Object, Object> m = new HashMap<Object, Object>();
        int i = 0;
        while (i < keysAndValues.length) {
            Object key = keysAndValues[i++];
            assert (key != null);
            Object value = keysAndValues[i++];
            assert (value != null);
            m.put(key, value);
        }
        return new TransformerWhichThrows<I, O, EX>(){

            @Override
            public O transform(I in) throws Throwable {
                Object out = m.get(in);
                if (out != null) {
                    return out;
                }
                return delegate.transform(in);
            }
        };
    }

    public static <I, O> Transformer<I, O> fromMappings(Object ... keysAndValues) {
        final HashMap<Object, Object> m = new HashMap<Object, Object>();
        int i = 0;
        while (i < keysAndValues.length) {
            m.put(keysAndValues[i++], keysAndValues[i++]);
        }
        return new Transformer<I, O>(){

            @Override
            public O transform(I in) {
                return m.get(in);
            }
        };
    }

    public static <I, O, EX extends Throwable> TransformerWhichThrows<I, O, EX> cache(TransformerWhichThrows<? super I, ? extends O, ? extends EX> delegate) {
        return TransformerUtil.cache(delegate, new WeakHashMap());
    }

    public static <I, O, EX extends Throwable> TransformerWhichThrows<I, O, EX> cache(final TransformerWhichThrows<? super I, ? extends O, ? extends EX> delegate, final Map<I, O> cache) {
        return new TransformerWhichThrows<I, O, EX>(){

            @Override
            public O transform(I in) throws Throwable {
                Object out = cache.get(in);
                if (out != null) {
                    return out;
                }
                out = delegate.transform(in);
                cache.put(in, out);
                return out;
            }
        };
    }

    public static <I, O, EX extends Throwable> Transformer<I, O> ignoreExceptions(final Class<EX> exceptionClass, final TransformerWhichThrows<I, O, EX> delegate, final O defaultValue) {
        return new Transformer<I, O>(){

            @Override
            public O transform(I in) {
                block6: {
                    try {
                        return delegate.transform(in);
                    }
                    catch (RuntimeException re) {
                        if (!exceptionClass.isAssignableFrom(re.getClass())) {
                            throw re;
                        }
                    }
                    catch (Error e) {
                        if (!exceptionClass.isAssignableFrom(e.getClass())) {
                            throw e;
                        }
                    }
                    catch (Throwable t) {
                        if ($assertionsDisabled || exceptionClass.isAssignableFrom(t.getClass())) break block6;
                        throw new AssertionError();
                    }
                }
                return defaultValue;
            }
        };
    }
}

