/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang.crypto;

import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.ObjectUtil;
import de.unkrig.commons.lang.crypto.Cryptor;
import de.unkrig.commons.lang.crypto.Cryptors;
import de.unkrig.commons.lang.crypto.Decryptors;
import de.unkrig.commons.lang.crypto.Encryptors;
import de.unkrig.commons.lang.crypto.MD5;
import de.unkrig.commons.lang.crypto.PasswordAuthenticationStore;
import de.unkrig.commons.lang.crypto.SaltException;
import de.unkrig.commons.lang.crypto.WrongKeyException;
import de.unkrig.commons.lang.security.DestroyableProperties;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;

public final class PasswordAuthenticationStores {
    private PasswordAuthenticationStores() {
    }

    public static PasswordAuthenticationStore propertiesPasswordAuthenticationStore(final DestroyableProperties delegate) {
        return new PasswordAuthenticationStore(){

            @Override
            @Nullable
            public String getUserName(String key) {
                char[] ca = delegate.getProperty(String.valueOf(key) + ".userName");
                return ca == null ? null : new String(ca);
            }

            @Override
            @Nullable
            public char[] getPassword(String key, String userName) {
                return delegate.getProperty(String.valueOf(key) + ".password");
            }

            @Override
            public void put(String key, String userName) throws IOException {
                String userNamePropertyName = String.valueOf(key) + ".userName";
                String passwordPropertyName = String.valueOf(key) + ".password";
                DestroyableProperties sps = delegate;
                sps.setProperty(userNamePropertyName, userName.toCharArray());
                sps.removeProperty(passwordPropertyName);
                sps.store();
            }

            @Override
            public void put(String key, String userName, char[] password) throws IOException {
                String userNamePropertyName = String.valueOf(key) + ".userName";
                String passwordPropertyName = String.valueOf(key) + ".password";
                DestroyableProperties sps = delegate;
                sps.setProperty(userNamePropertyName, userName.toCharArray());
                sps.setProperty(passwordPropertyName, password);
                sps.store();
            }

            @Override
            public void remove(String key) throws IOException {
                String userNamePropertyName = String.valueOf(key) + ".userName";
                String passwordPropertyName = String.valueOf(key) + ".password";
                DestroyableProperties sps = delegate;
                sps.removeProperty(userNamePropertyName);
                sps.removeProperty(passwordPropertyName);
                sps.store();
            }

            @Override
            public void destroy() throws DestroyFailedException {
                delegate.destroy();
            }

            @Override
            public boolean isDestroyed() {
                return delegate.isDestroyed();
            }
        };
    }

    public static PasswordAuthenticationStore encryptPasswords(SecretKey secretKey, final PasswordAuthenticationStore delegate) {
        final Cryptor c = Cryptors.addChecksum(Cryptors.fromSecretKey(secretKey));
        return new PasswordAuthenticationStore(){

            @Override
            @Nullable
            public String getUserName(String key) {
                return delegate.getUserName(key);
            }

            @Override
            @Nullable
            public char[] getPassword(String key, String userName) {
                char[] password = delegate.getPassword(key, userName);
                try {
                    return password == null ? null : Decryptors.decrypt(c, MD5.of(userName), new String(password));
                }
                catch (WrongKeyException wke) {
                    return null;
                }
                catch (SaltException e) {
                    return null;
                }
            }

            @Override
            public void put(String key, String userName) throws IOException {
                delegate.put(key, userName);
            }

            @Override
            public void put(String key, String userName, char[] password) throws IOException {
                delegate.put(key, userName, Encryptors.encrypt(c, MD5.of(userName), password).toCharArray());
            }

            @Override
            public void remove(String key) throws IOException {
                delegate.remove(key);
            }

            @Override
            public void destroy() throws DestroyFailedException {
                c.destroy();
                delegate.isDestroyed();
            }

            @Override
            public boolean isDestroyed() {
                return c.isDestroyed() && delegate.isDestroyed();
            }
        };
    }

    public static DestroyableProperties propertiesFileDestroyableProperties(final File propertiesFile, final String comments) throws IOException {
        Properties properties;
        block11: {
            properties = new Properties();
            propertiesFile.createNewFile();
            FileInputStream is = new FileInputStream(propertiesFile);
            try {
                try {
                    properties.load(is);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Exception exception) {}
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                ((InputStream)is).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new DestroyableProperties(){
            private boolean dirty;
            private boolean destroyed;

            @Override
            public synchronized void store() throws IOException {
                if (this.destroyed) {
                    throw new IllegalStateException();
                }
                if (!this.dirty) {
                    return;
                }
                File newFile = new File(propertiesFile.getParentFile(), "." + propertiesFile.getName() + ",new");
                FileOutputStream os = new FileOutputStream(newFile);
                try {
                    try {
                        properties.store(os, comments);
                        ((OutputStream)os).close();
                    }
                    catch (IOException ioe) {
                        try {
                            ((OutputStream)os).close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            newFile.delete();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw ExceptionUtil.wrap("Creating temporary properties file", ioe);
                    }
                }
                finally {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (Exception exception) {}
                }
                File origFile = new File(propertiesFile.getParentFile(), "." + propertiesFile.getName() + ",orig");
                if (origFile.exists()) {
                    PasswordAuthenticationStores.delete(origFile);
                }
                if (propertiesFile.exists()) {
                    PasswordAuthenticationStores.rename(propertiesFile, origFile);
                    PasswordAuthenticationStores.rename(newFile, propertiesFile);
                    PasswordAuthenticationStores.delete(origFile);
                } else {
                    PasswordAuthenticationStores.rename(newFile, propertiesFile);
                }
                this.dirty = false;
            }

            @Override
            public int size() {
                if (this.destroyed) {
                    throw new IllegalStateException();
                }
                return properties.size();
            }

            @Override
            public synchronized void setProperty(String key, char[] value) {
                if (this.destroyed) {
                    throw new IllegalStateException();
                }
                Object previous = properties.setProperty(key, new String(value));
                this.dirty |= !ObjectUtil.equals(value, previous);
            }

            @Override
            public void removeProperty(String name) {
                if (this.destroyed) {
                    throw new IllegalStateException();
                }
                Object previous = properties.remove(name);
                this.dirty |= previous != null;
            }

            @Override
            public void putAll(Map<? extends String, ? extends CharSequence> t) {
                if (this.destroyed) {
                    throw new IllegalStateException();
                }
                for (Map.Entry<? extends String, ? extends CharSequence> e : t.entrySet()) {
                    String key = e.getKey();
                    CharSequence value = e.getValue();
                    properties.put(key, value.toString());
                }
            }

            @Override
            public void put(String name, CharSequence value) {
                if (this.destroyed) {
                    throw new IllegalStateException();
                }
                properties.put(name, value.toString());
            }

            @Override
            public Set<String> propertyNames() {
                if (this.destroyed) {
                    throw new IllegalStateException();
                }
                return properties.stringPropertyNames();
            }

            @Override
            public boolean isEmpty() {
                if (this.destroyed) {
                    throw new IllegalStateException();
                }
                return properties.isEmpty();
            }

            @Override
            @Nullable
            public char[] getProperty(String key) {
                if (this.destroyed) {
                    throw new IllegalStateException();
                }
                String result = properties.getProperty(key);
                return result == null ? null : result.toCharArray();
            }

            @Override
            public boolean containsName(String name) {
                if (this.destroyed) {
                    throw new IllegalStateException();
                }
                return properties.containsKey(name);
            }

            @Override
            public void clear() {
                if (this.destroyed) {
                    throw new IllegalStateException();
                }
                properties.clear();
            }

            @Override
            public void destroy() {
                this.destroyed = true;
            }

            @Override
            public boolean isDestroyed() {
                return this.destroyed;
            }
        };
    }

    private static void rename(File oldFile, File newFile) throws IOException {
        if (!oldFile.renameTo(newFile)) {
            throw new IOException("Unable to rename \"" + oldFile + "\" to \"" + newFile + "\"");
        }
    }

    private static void delete(File file) throws IOException {
        if (!file.delete()) {
            throw new IOException("Unable to delete \"" + file + "\"");
        }
    }
}

