/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang.crypto;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.crypto.Encryptor;
import de.unkrig.commons.lang.crypto.MD5;
import de.unkrig.commons.lang.java6.Base64;
import de.unkrig.commons.lang.security.SecureCharsets;
import de.unkrig.commons.nullanalysis.Nullable;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

public final class Encryptors {
    static {
        AssertionUtil.enableAssertionsForThisClass();
    }

    private Encryptors() {
    }

    public static Encryptor fromKey(final Key key) {
        Cipher cipher;
        String algorithm = key.getAlgorithm();
        try {
            cipher = Cipher.getInstance(algorithm);
        }
        catch (GeneralSecurityException gse) {
            throw new AssertionError((Object)gse);
        }
        return new Encryptor(){
            private boolean destroyed;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] encrypt(byte[] unencrypted) {
                if (this.destroyed) {
                    throw new IllegalStateException();
                }
                try {
                    Cipher cipher2 = cipher;
                    synchronized (cipher2) {
                        try {
                            cipher.init(1, key);
                            byte[] byArray = cipher.doFinal(unencrypted);
                            return byArray;
                        }
                        catch (Throwable throwable) {
                            try {
                                throw throwable;
                            }
                            catch (GeneralSecurityException gse) {
                                throw new AssertionError((Object)gse);
                            }
                        }
                    }
                }
                finally {
                    Arrays.fill(unencrypted, (byte)0);
                }
            }

            @Override
            public void destroy() throws DestroyFailedException {
                if (cipher instanceof Destroyable) {
                    ((Destroyable)((Object)cipher)).destroy();
                }
                this.destroyed = true;
            }

            @Override
            public boolean isDestroyed() {
                return this.destroyed;
            }
        };
    }

    public static Encryptor addChecksum(final Encryptor delegate) {
        return new Encryptor(){

            @Override
            public byte[] encrypt(byte[] unencrypted) {
                byte[] md5 = MD5.of(unencrypted);
                if (!$assertionsDisabled && md5.length != 16) {
                    throw new AssertionError();
                }
                byte[] tmp = unencrypted;
                unencrypted = Arrays.copyOf(unencrypted, unencrypted.length + 16);
                System.arraycopy(md5, 0, unencrypted, unencrypted.length - 16, 16);
                Arrays.fill(tmp, (byte)0);
                return delegate.encrypt(unencrypted);
            }

            @Override
            public void destroy() throws DestroyFailedException {
                delegate.destroy();
            }

            @Override
            public boolean isDestroyed() {
                return delegate.isDestroyed();
            }
        };
    }

    public static String encrypt(Encryptor encryptor, char[] subject) {
        return Encryptors.encrypt(encryptor, null, subject);
    }

    public static String encrypt(Encryptor encryptor, @Nullable byte[] salt, char[] subject) {
        byte[] unencryptedBytes = SecureCharsets.secureEncode(subject, Charset.forName("UTF-8"));
        if (salt != null && salt.length > 0) {
            byte[] tmp = unencryptedBytes;
            unencryptedBytes = Arrays.copyOf(salt, salt.length + tmp.length);
            System.arraycopy(tmp, 0, unencryptedBytes, salt.length, tmp.length);
            Arrays.fill(tmp, (byte)0);
        }
        byte[] encryptedBytes = encryptor.encrypt(unencryptedBytes);
        return Base64.encode(encryptedBytes);
    }
}

