/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang.crypto;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.crypto.Decryptor;
import de.unkrig.commons.lang.crypto.MD5;
import de.unkrig.commons.lang.crypto.SaltException;
import de.unkrig.commons.lang.crypto.WrongKeyException;
import de.unkrig.commons.lang.java6.Base64;
import de.unkrig.commons.lang.security.SecureCharsets;
import de.unkrig.commons.nullanalysis.Nullable;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

public final class Decryptors {
    static {
        AssertionUtil.enableAssertionsForThisClass();
    }

    private Decryptors() {
    }

    public static Decryptor fromKey(final Key key) {
        Cipher cipher;
        String algorithm = key.getAlgorithm();
        try {
            cipher = Cipher.getInstance(algorithm);
        }
        catch (GeneralSecurityException gse) {
            throw new AssertionError((Object)gse);
        }
        return new Decryptor(){
            private boolean destroyed;

            @Override
            public byte[] decrypt(byte[] encrypted) throws WrongKeyException {
                if (this.destroyed) {
                    throw new IllegalStateException();
                }
                try {
                    Cipher cipher2 = cipher;
                    synchronized (cipher2) {
                        cipher.init(2, key);
                        try {
                            byte[] byArray = cipher.doFinal(encrypted);
                            return byArray;
                        }
                        catch (BadPaddingException bpe) {
                            try {
                                throw new WrongKeyException();
                            }
                            catch (GeneralSecurityException gse) {
                                throw new AssertionError((Object)gse);
                            }
                        }
                    }
                }
                finally {
                    Arrays.fill(encrypted, (byte)0);
                }
            }

            @Override
            public void destroy() throws DestroyFailedException {
                if (cipher instanceof Destroyable) {
                    ((Destroyable)((Object)cipher)).destroy();
                }
                this.destroyed = true;
            }

            @Override
            public boolean isDestroyed() {
                return this.destroyed;
            }
        };
    }

    public static Decryptor addChecksum(final Decryptor delegate) {
        return new Decryptor(){

            @Override
            public byte[] decrypt(byte[] encrypted) throws WrongKeyException {
                byte[] decrypted = delegate.decrypt(encrypted);
                if (decrypted.length < 16) {
                    Arrays.fill(decrypted, (byte)0);
                    throw new WrongKeyException();
                }
                byte[] md5 = MD5.of(decrypted, 0, decrypted.length - 16);
                if (!$assertionsDisabled && md5.length != 16) {
                    throw new AssertionError();
                }
                if (!Decryptors.arrayEquals(decrypted, decrypted.length - 16, md5, 0, 16)) {
                    Arrays.fill(decrypted, (byte)0);
                    throw new WrongKeyException();
                }
                byte[] tmp = decrypted;
                decrypted = Arrays.copyOf(decrypted, decrypted.length - 16);
                Arrays.fill(tmp, (byte)0);
                return decrypted;
            }

            @Override
            public void destroy() throws DestroyFailedException {
                delegate.destroy();
            }

            @Override
            public boolean isDestroyed() {
                return delegate.isDestroyed();
            }
        };
    }

    public static char[] decrypt(Decryptor decryptor, String subject) throws WrongKeyException {
        try {
            return Decryptors.decrypt(decryptor, null, subject);
        }
        catch (SaltException se) {
            throw new AssertionError((Object)se);
        }
    }

    public static char[] decrypt(Decryptor decryptor, @Nullable byte[] salt, String subject) throws WrongKeyException, SaltException {
        byte[] encryptedBytes = Base64.decode(subject);
        byte[] decryptedBytes = decryptor.decrypt(encryptedBytes);
        if (salt != null && salt.length > 0) {
            if (decryptedBytes.length < salt.length || !Decryptors.arrayEquals(decryptedBytes, 0, salt, 0, salt.length)) {
                throw new SaltException();
            }
            byte[] tmp = decryptedBytes;
            decryptedBytes = Arrays.copyOfRange(decryptedBytes, salt.length, decryptedBytes.length);
            Arrays.fill(tmp, (byte)0);
        }
        return SecureCharsets.secureDecode(decryptedBytes, Charset.forName("UTF8"));
    }

    private static boolean arrayEquals(byte[] ba1, int ba1pos, byte[] ba2, int ba2pos, int length) {
        if (ba1pos + length > ba1.length) {
            throw new IllegalArgumentException();
        }
        if (ba2pos + length > ba2.length) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < length) {
            if (ba1[ba1pos + i] != ba2[ba2pos + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

