/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang;

import de.unkrig.commons.nullanalysis.Nullable;
import java.lang.reflect.Field;
import org.xml.sax.SAXParseException;

public final class ExceptionUtil {
    private static final Field THROWABLE_DETAIL_MESSAGE_FIELD = ExceptionUtil.getDeclaredField(Throwable.class, "detailMessage");

    private ExceptionUtil() {
    }

    private static Field getDeclaredField(Class<Throwable> declaringClass, String fieldName) {
        try {
            Field f = declaringClass.getDeclaredField(fieldName);
            f.setAccessible(true);
            return f;
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static <T extends Throwable> T wrap(@Nullable String prefix, T cause) {
        Throwable wrapper;
        block13: {
            String causeMessage;
            Class<?> causeClass = cause.getClass();
            try {
                causeMessage = (String)THROWABLE_DETAIL_MESSAGE_FIELD.get(cause);
            }
            catch (Exception e22) {
                causeMessage = cause.getMessage();
            }
            String message = prefix == null ? causeMessage : (causeMessage == null ? prefix : String.valueOf(prefix) + ": " + causeMessage);
            try {
                wrapper = (Throwable)causeClass.getConstructor(String.class, Throwable.class).newInstance(message, cause);
            }
            catch (Exception e22) {
                try {
                    wrapper = (Throwable)causeClass.getConstructor(String.class).newInstance(message);
                    wrapper.initCause(cause);
                }
                catch (Exception e22) {
                    try {
                        wrapper = (Throwable)causeClass.getConstructor(Object.class).newInstance(message);
                        wrapper.initCause(cause);
                    }
                    catch (Exception e22) {
                        if (cause instanceof SAXParseException) {
                            SAXParseException spe = (SAXParseException)cause;
                            wrapper = new SAXParseException(message, spe.getPublicId(), spe.getSystemId(), spe.getLineNumber(), spe.getColumnNumber());
                            wrapper.initCause(cause);
                            break block13;
                        }
                        if (cause.getClass().getName().equals("org.junit.ComparisonFailure")) {
                            try {
                                wrapper = (Throwable)causeClass.getConstructor(String.class, String.class, String.class).newInstance(message, causeClass.getMethod("getExpected", new Class[0]).invoke(cause, new Object[0]), causeClass.getMethod("getActual", new Class[0]).invoke(cause, new Object[0]));
                                wrapper.initCause(cause);
                                break block13;
                            }
                            catch (Exception spe) {
                                // empty catch block
                            }
                        }
                        return cause;
                    }
                }
            }
        }
        StackTraceElement[] st = wrapper.getStackTrace();
        int i = 0;
        while (true) {
            if ("wrap".equals(st[i].getMethodName())) break;
            ++i;
        }
        StackTraceElement[] st2 = new StackTraceElement[st.length - ++i];
        System.arraycopy(st, i, st2, 0, st2.length);
        wrapper.setStackTrace(st2);
        return (T)wrapper;
    }

    public static <T extends Throwable> T wrap(@Nullable String prefix, Throwable cause, Class<T> wrapperClass) {
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix).append(": ");
        }
        sb.append(cause.getClass().getName());
        String causeMessage = cause.getMessage();
        if (causeMessage != null) {
            sb.append(": ").append(causeMessage);
        } else {
            Throwable t = cause.getCause();
            while (t != null) {
                sb.append(": ").append(t.getClass().getName());
                String tMessage = t.getMessage();
                if (tMessage != null) {
                    sb.append(": ").append(tMessage);
                    break;
                }
                t = t.getCause();
            }
        }
        String message = sb.toString();
        try {
            return (T)((Throwable)wrapperClass.getConstructor(String.class, Throwable.class).newInstance(message, cause));
        }
        catch (Exception tMessage) {
            try {
                Throwable wrapper = (Throwable)wrapperClass.getConstructor(String.class).newInstance(message);
                wrapper.initCause(cause);
                return (T)wrapper;
            }
            catch (Exception wrapper) {
                try {
                    Throwable wrapper2 = (Throwable)wrapperClass.getConstructor(Object.class).newInstance(message);
                    wrapper2.initCause(cause);
                    return (T)wrapper2;
                }
                catch (Exception wrapper2) {
                    try {
                        Throwable wrapper3 = (Throwable)wrapperClass.newInstance();
                        wrapper3.initCause(cause);
                        return (T)wrapper3;
                    }
                    catch (Exception wrapper3) {
                        if (wrapperClass.isAssignableFrom(cause.getClass())) {
                            Throwable result = cause;
                            return (T)result;
                        }
                        AssertionError ae = new AssertionError((Object)("Exception class '" + wrapperClass.getName() + "' has no suitable constructor"));
                        ((Throwable)((Object)ae)).initCause(cause);
                        throw ae;
                    }
                }
            }
        }
    }

    public static void throwUndeclared(Exception e) {
        ExceptionUtil.throwUndeclared2(e);
    }

    private static <EX extends Exception> void throwUndeclared2(Exception e) throws EX {
        throw e;
    }

    public static <T, EX extends Throwable> T throW(EX throwable) throws EX {
        throw throwable;
    }

    public static <T> T throwAssertionError(Object object) {
        throw new AssertionError(object);
    }
}

