/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang;

import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class ClassLoaders {
    private ClassLoaders() {
    }

    public static URL[] getAllSubresources(@Nullable ClassLoader classLoader, String name, boolean includeDirectories) throws IOException {
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        assert (classLoader != null);
        ArrayList<URL> result = new ArrayList<URL>();
        for (URL r : Collections.list(classLoader.getResources(name))) {
            result.addAll(ClassLoaders.getSubresourcesOf(r, name, includeDirectories).values());
        }
        return result.toArray(new URL[result.size()]);
    }

    public static Map<String, URL> getSubresources(@Nullable ClassLoader classLoader, String name, boolean includeDirectories) throws IOException {
        return ClassLoaders.getSubresources(classLoader, name, includeDirectories, true);
    }

    public static Map<String, URL> getSubresources(@Nullable ClassLoader classLoader, String name, boolean includeDirectories, boolean recurse) throws IOException {
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        assert (classLoader != null);
        URL r = classLoader.getResource(name);
        if (r == null) {
            String protocol;
            if (name.startsWith("java/") && name.endsWith("/") && (r = classLoader.getResource("java/lang/Object.class")) != null && "jar".equalsIgnoreCase(protocol = r.getProtocol())) {
                JarURLConnection juc = (JarURLConnection)r.openConnection();
                juc.setUseCaches(false);
                URL jarFileUrl = juc.getJarFileURL();
                JarFile jarFile = juc.getJarFile();
                Map<String, URL> result = ClassLoaders.getSubresources(jarFileUrl, jarFile, name, includeDirectories, recurse);
                return result;
            }
            return Collections.emptyMap();
        }
        return ClassLoaders.getSubresourcesOf(r, name, includeDirectories, recurse);
    }

    public static Map<String, URL> getSubresourcesOf(URL root, String rootName, boolean includeDirectories) throws IOException {
        return ClassLoaders.getSubresourcesOf(root, rootName, includeDirectories, true);
    }

    public static Map<String, URL> getSubresourcesOf(URL root, String rootName, boolean includeDirectories, boolean recurse) throws IOException {
        String protocol = root.getProtocol();
        if ("jar".equalsIgnoreCase(protocol)) {
            JarURLConnection juc = (JarURLConnection)root.openConnection();
            juc.setUseCaches(false);
            if (!juc.getJarEntry().isDirectory()) {
                return Collections.singletonMap(rootName, root);
            }
            URL jarFileUrl = juc.getJarFileURL();
            JarFile jarFile = juc.getJarFile();
            Map<String, URL> result = ClassLoaders.getSubresources(jarFileUrl, jarFile, rootName, includeDirectories, recurse);
            if (includeDirectories) {
                result.put(rootName, root);
            }
            return result;
        }
        if ("file".equalsIgnoreCase(protocol)) {
            return ClassLoaders.getFileResources(root, rootName, includeDirectories, recurse);
        }
        return Collections.singletonMap(rootName, root);
    }

    private static Map<String, URL> getSubresources(URL jarFileUrl, JarFile jarFile, String namePrefix, boolean includeDirectories, boolean recurse) {
        HashMap<String, URL> result = new HashMap<String, URL>();
        for (JarEntry je : Collections.list(jarFile.entries())) {
            URL url;
            if (je.isDirectory() && !includeDirectories || !je.getName().startsWith(namePrefix) || !recurse && je.getName().indexOf(47, namePrefix.length()) != -1) continue;
            try {
                url = new URL("jar", null, String.valueOf(jarFileUrl.toString()) + "!/" + je.getName());
            }
            catch (MalformedURLException mue) {
                throw new AssertionError((Object)mue);
            }
            result.put(je.getName(), url);
        }
        return result;
    }

    private static Map<String, URL> getFileResources(URL fileUrl, String namePrefix, boolean includeDirectories, boolean recurse) throws IOException {
        File file = new File(fileUrl.getFile());
        if (file.isFile()) {
            return Collections.singletonMap(namePrefix, fileUrl);
        }
        if (file.isDirectory()) {
            File[] members;
            if (!namePrefix.isEmpty() && !namePrefix.endsWith("/")) {
                namePrefix = String.valueOf(namePrefix) + '/';
            }
            HashMap<String, URL> result = new HashMap<String, URL>();
            if (includeDirectories) {
                result.put(namePrefix, fileUrl);
            }
            if ((members = file.listFiles()) == null) {
                throw new IOException(file + ": Permission denied");
            }
            File[] fileArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                File member = fileArray[n2];
                String memberName = String.valueOf(namePrefix) + member.getName();
                URL memberUrl = ClassLoaders.fileUrl(member);
                if (recurse) {
                    result.putAll(ClassLoaders.getFileResources(memberUrl, memberName, includeDirectories, recurse));
                } else if (member.isFile()) {
                    result.put(memberName, memberUrl);
                }
                ++n2;
            }
            return result;
        }
        return Collections.emptyMap();
    }

    private static URL fileUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException mue) {
            throw ExceptionUtil.wrap(file.toString(), mue, IllegalStateException.class);
        }
    }
}

