/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.junit4;

import de.unkrig.commons.nullanalysis.Nullable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;

public final class AssertRegex {
    private AssertRegex() {
    }

    public static void assertMatches(String expectedRegex, String actual) {
        AssertRegex.assertMatches(null, expectedRegex, actual);
    }

    public static void assertMatches(@Nullable String message, String expectedRegex, String actual) {
        Pattern pattern = Pattern.compile(expectedRegex);
        Matcher matcher = pattern.matcher(actual);
        if (!matcher.matches()) {
            int mismatchOffset = AssertRegex.mismatchOffset(pattern, actual);
            String s = actual.substring(mismatchOffset);
            if (s.length() > 10) {
                s = String.valueOf(s.substring(0, 8)) + "...";
            }
            Assert.fail((String)(String.valueOf(message == null ? "[" : String.valueOf(message) + ": [") + actual + "] did not match regex [" + expectedRegex + "] at offset " + mismatchOffset + ": \"" + s + "\""));
        }
    }

    private static int mismatchOffset(Pattern pattern, String subject) {
        int i = subject.length();
        while (i >= 0) {
            Matcher matcher = pattern.matcher(subject.substring(0, i));
            if (matcher.matches()) {
                return i;
            }
            if (matcher.hitEnd()) {
                return i;
            }
            --i;
        }
        return 0;
    }

    public static void assertMatches(List<String> expectedRegexes, List<String> actuals) {
        AssertRegex.assertMatches(null, expectedRegexes, actuals);
    }

    public static void assertMatches(@Nullable String message, List<String> expectedRegexes, List<String> actuals) {
        int i = 0;
        while (i < expectedRegexes.size() && i < actuals.size()) {
            String expectedRegex = expectedRegexes.get(i);
            String actual = actuals.get(i);
            AssertRegex.assertMatches(String.valueOf(message == null ? "Element " : String.valueOf(message) + ": Element ") + i, expectedRegex, actual);
            ++i;
        }
        if (expectedRegexes.size() != actuals.size()) {
            Assert.fail((String)(String.valueOf(message == null ? "Expected " : String.valueOf(message) + ": Expected ") + expectedRegexes.size() + " strings, but got " + actuals.size()));
        }
    }

    public static void assertFind(String expectedRegex, String actual) {
        AssertRegex.assertFind(null, expectedRegex, actual);
    }

    public static void assertFind(@Nullable String message, String expectedRegex, String actual) {
        Pattern pattern = Pattern.compile(expectedRegex);
        Matcher matcher = pattern.matcher(actual);
        if (!matcher.find()) {
            Assert.fail((String)(String.valueOf(message == null ? "regex [" : String.valueOf(message) + ": regex [") + expectedRegex + "] not found in [" + actual + "]"));
        }
    }
}

