/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class WyeReader
extends FilterReader {
    private final Writer out;

    static {
        AssertionUtil.enableAssertionsForThisClass();
    }

    public WyeReader(Reader in, Writer out) {
        super(in);
        this.out = out;
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        if (b == -1) {
            this.out.flush();
        } else {
            this.out.write(b);
        }
        return b;
    }

    @Override
    public int read(@Nullable char[] cbuf, int off, int len) throws IOException {
        assert (cbuf != null);
        int count = super.read(cbuf, off, len);
        if (count > 0) {
            this.out.write(cbuf, off, count);
        }
        if (count == 0) {
            this.out.flush();
        }
        return count;
    }
}

