/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.nullanalysis.NotNullByDefault;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

@NotNullByDefault(value=false)
public class CountingReader
extends FilterReader {
    private int offset;
    private int lineNumber = 1;
    private int columnNumber;
    private boolean crPending;

    public CountingReader(Reader in) {
        super(in);
    }

    public int offset() {
        return this.offset;
    }

    public int lineNumber() {
        return this.lineNumber;
    }

    public int columnNumber() {
        return this.columnNumber;
    }

    @Override
    public int read() throws IOException {
        int c = super.read();
        if (c == -1) {
            return -1;
        }
        ++this.offset;
        if (this.crPending) {
            this.crPending = false;
            if (c == 10) {
                return c;
            }
        }
        if (c == 13 || c == 10) {
            ++this.lineNumber;
            this.columnNumber = 0;
            if (c == 13) {
                this.crPending = true;
            }
        } else {
            ++this.columnNumber;
        }
        return c;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (len <= 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        int n = 1;
        while (true) {
            cbuf[off++] = (char)c;
            if (--len == 0) {
                return n;
            }
            c = this.read();
            if (c == -1) {
                return n;
            }
            ++n;
        }
    }
}

