/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.io.CharFilter;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.FilterReader;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;

public class CharFilterReader
extends FilterReader {
    private final Thread worker;
    @Nullable
    private IOException charFilterIOException;
    @Nullable
    private RuntimeException charFilterRuntimeException;

    public CharFilterReader(final Reader in, final CharFilter<?> charFilter) {
        super(new PipedReader());
        PipedWriter pw;
        try {
            pw = new PipedWriter((PipedReader)this.in);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.worker = new Thread("CharFilterReader"){

            @Override
            public void run() {
                try {
                    try {
                        charFilter.run(in, pw);
                    }
                    catch (IOException ioe) {
                        CharFilterReader.this.charFilterIOException = ioe;
                        try {
                            pw.close();
                        }
                        catch (IOException iOException) {}
                    }
                    catch (RuntimeException re) {
                        CharFilterReader.this.charFilterRuntimeException = re;
                        try {
                            pw.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    try {
                        pw.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        this.worker.start();
    }

    @Override
    public int read() throws IOException {
        int n;
        char[] buffer = new char[1];
        do {
            if ((n = this.read(buffer, 0, 1)) == -1) {
                return -1;
            }
            if (n != 1) continue;
            return 0xFF & buffer[0];
        } while (n == 0);
        throw new IllegalStateException();
    }

    @Override
    @NotNullByDefault(value=false)
    public int read(char[] b, int off, int len) throws IOException {
        int n = this.in.read(b, off, len);
        if (this.charFilterIOException != null) {
            throw ExceptionUtil.wrap("CharFilterReader", this.charFilterIOException);
        }
        if (this.charFilterRuntimeException != null) {
            throw ExceptionUtil.wrap("CharFilterReader", this.charFilterRuntimeException);
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            while (true) {
                try {
                    this.worker.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        if (this.charFilterIOException != null) {
            throw ExceptionUtil.wrap("CharFilterReader", this.charFilterIOException);
        }
        if (this.charFilterRuntimeException != null) {
            throw ExceptionUtil.wrap("CharFilterReader", this.charFilterRuntimeException);
        }
    }
}

